/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.api;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;

@ExecutableCheck(reportedProblems={ProblemType.COMMON_REIMPLEMENTATION_SQRT, ProblemType.COMMON_REIMPLEMENTATION_HYPOT, ProblemType.COMMON_REIMPLEMENTATION_MAX_MIN})
public class MathReimplementation
extends IntegratedCheck {
    private static boolean isMathPow(CtInvocation<?> ctInvocation) {
        CtTypeAccess ctTypeAccess;
        CtExpression ctExpression = ctInvocation.getTarget();
        return ctExpression instanceof CtTypeAccess && SpoonUtil.isTypeEqualTo((ctTypeAccess = (CtTypeAccess)ctExpression).getAccessedType(), Math.class) && SpoonUtil.isSignatureEqualTo(ctInvocation.getExecutable(), Double.TYPE, "pow", Double.TYPE, Double.TYPE);
    }

    private static boolean isMathSqrt(CtInvocation<?> ctInvocation) {
        CtTypeAccess ctTypeAccess;
        CtExpression ctExpression = ctInvocation.getTarget();
        return ctExpression instanceof CtTypeAccess && SpoonUtil.isTypeEqualTo((ctTypeAccess = (CtTypeAccess)ctExpression).getAccessedType(), Math.class) && SpoonUtil.isSignatureEqualTo(ctInvocation.getExecutable(), Double.TYPE, "sqrt", Double.TYPE);
    }

    private static boolean isPowSqrt(CtInvocation<?> ctInvocation) {
        Double doubleValue;
        CtLiteral ctLiteral;
        Object object;
        return MathReimplementation.isMathPow(ctInvocation) && ctInvocation.getArguments().size() == 2 && (object = SpoonUtil.resolveConstant((CtExpression)ctInvocation.getArguments().get(1))) instanceof CtLiteral && (object = (ctLiteral = (CtLiteral)object).getValue()) instanceof Double && (doubleValue = (Double)object) == 0.5;
    }

    private static Optional<CtExpression<?>> getPow2(CtExpression<?> ctExpression) {
        Number value;
        CtLiteral ctLiteral;
        Object object;
        CtInvocation ctInvocation;
        CtBinaryOperator ctBinaryOperator;
        if (ctExpression instanceof CtBinaryOperator && (ctBinaryOperator = (CtBinaryOperator)ctExpression).getLeftHandOperand().equals(ctBinaryOperator.getRightHandOperand()) && ctBinaryOperator.getKind() == BinaryOperatorKind.MUL) {
            return Optional.of(ctBinaryOperator.getLeftHandOperand());
        }
        if (ctExpression instanceof CtInvocation && MathReimplementation.isMathPow(ctInvocation = (CtInvocation)ctExpression) && (object = ctInvocation.getArguments().get(1)) instanceof CtLiteral && (object = (ctLiteral = (CtLiteral)object).getValue()) instanceof Number && (value = (Number)object).doubleValue() == 2.0) {
            return Optional.of((CtExpression)ctInvocation.getArguments().get(0));
        }
        return Optional.empty();
    }

    private boolean checkHypot(CtExpression<?> ctExpression) {
        CtBinaryOperator ctBinaryOperator;
        Object e;
        CtInvocation ctInvocation;
        if (!(ctExpression instanceof CtInvocation) || !MathReimplementation.isMathSqrt(ctInvocation = (CtInvocation)ctExpression) && !MathReimplementation.isPowSqrt(ctInvocation) || !((e = ctInvocation.getArguments().get(0)) instanceof CtBinaryOperator) || (ctBinaryOperator = (CtBinaryOperator)e).getKind() != BinaryOperatorKind.PLUS) {
            return false;
        }
        Optional<CtExpression<?>> left = MathReimplementation.getPow2(ctBinaryOperator.getLeftHandOperand());
        Optional<CtExpression<?>> right = MathReimplementation.getPow2(ctBinaryOperator.getRightHandOperand());
        if (left.isPresent() && right.isPresent()) {
            this.addLocalProblem((CtElement)ctExpression, (Translatable)new LocalizedMessage("common-reimplementation", Map.of("suggestion", "Math.hypot(%s, %s)".formatted(left.get().prettyprint(), right.get().prettyprint()))), ProblemType.COMMON_REIMPLEMENTATION_HYPOT);
            return true;
        }
        return false;
    }

    private void checkSqrt(CtExpression<?> ctExpression) {
        CtInvocation ctInvocation;
        if (!(ctExpression instanceof CtInvocation) || !MathReimplementation.isMathPow(ctInvocation = (CtInvocation)ctExpression)) {
            return;
        }
        if (MathReimplementation.isPowSqrt(ctInvocation)) {
            this.addLocalProblem((CtElement)ctExpression, (Translatable)new LocalizedMessage("common-reimplementation", Map.of("suggestion", "Math.sqrt(%s)".formatted(((CtExpression)ctInvocation.getArguments().get(0)).prettyprint()))), ProblemType.COMMON_REIMPLEMENTATION_SQRT);
        }
    }

    private void checkMaxMin(CtIf ctIf) {
        CtBinaryOperator ctBinaryOperator;
        CtVariableWrite ctVariableWrite;
        CtAssignment thenAssignment;
        Set<BinaryOperatorKind> minOperators;
        Set<BinaryOperatorKind> maxOperators;
        block11: {
            block10: {
                CtStatement ctStatement;
                maxOperators = Set.of(BinaryOperatorKind.LT, BinaryOperatorKind.LE);
                minOperators = Set.of(BinaryOperatorKind.GT, BinaryOperatorKind.GE);
                List<CtStatement> thenBlock = SpoonUtil.getEffectiveStatements(ctIf.getThenStatement());
                if (thenBlock.size() != 1 || !((ctStatement = thenBlock.get(0)) instanceof CtAssignment) || !((ctStatement = (thenAssignment = (CtAssignment)ctStatement).getAssigned()) instanceof CtVariableWrite)) break block10;
                ctVariableWrite = (CtVariableWrite)ctStatement;
                ctStatement = ctIf.getCondition();
                if (ctStatement instanceof CtBinaryOperator && (maxOperators.contains((ctBinaryOperator = (CtBinaryOperator)ctStatement).getKind()) || minOperators.contains(ctBinaryOperator.getKind()))) break block11;
            }
            return;
        }
        CtVariableReference assignedVariable = ctVariableWrite.getVariable();
        CtVariableAccess elseValue = ctIf.getFactory().createVariableRead(assignedVariable.clone(), assignedVariable.getModifiers().contains(ModifierKind.STATIC));
        if (ctIf.getElseStatement() != null) {
            CtVariableAccess elseAccess;
            CtAssignment elseAssignment;
            CtStatement ctStatement;
            List<CtStatement> elseBlock = SpoonUtil.getEffectiveStatements(ctIf.getElseStatement());
            if (!(elseBlock.size() == 1 && (ctStatement = elseBlock.get(0)) instanceof CtAssignment && (ctStatement = (elseAssignment = (CtAssignment)ctStatement).getAssigned()) instanceof CtVariableAccess && (elseAccess = (CtVariableAccess)ctStatement).getVariable().equals(assignedVariable))) {
                return;
            }
            elseValue = elseAssignment.getAssignment();
        }
        CtBinaryOperator condition = ctBinaryOperator;
        if (ctBinaryOperator.getRightHandOperand().equals(elseValue)) {
            condition = SpoonUtil.swapCtBinaryOperator(condition);
        }
        if (!condition.getLeftHandOperand().equals(elseValue)) {
            return;
        }
        if (!condition.getLeftHandOperand().equals(thenAssignment.getAssignment()) && !condition.getRightHandOperand().equals(thenAssignment.getAssignment())) {
            return;
        }
        if (maxOperators.contains(condition.getKind())) {
            this.addLocalProblem((CtElement)ctIf, (Translatable)new LocalizedMessage("common-reimplementation", Map.of("suggestion", "%s = Math.max(%s, %s)".formatted(ctVariableWrite.prettyprint(), elseValue.prettyprint(), condition.getRightHandOperand().prettyprint()))), ProblemType.COMMON_REIMPLEMENTATION_MAX_MIN);
            return;
        }
        if (minOperators.contains(condition.getKind())) {
            this.addLocalProblem((CtElement)ctIf, (Translatable)new LocalizedMessage("common-reimplementation", Map.of("suggestion", "%s = Math.min(%s, %s)".formatted(ctVariableWrite.prettyprint(), elseValue.prettyprint(), condition.getRightHandOperand().prettyprint()))), ProblemType.COMMON_REIMPLEMENTATION_MAX_MIN);
            return;
        }
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.getModel().getRootPackage().accept((CtVisitor)new CtScanner(){

            protected void enter(CtElement ctElement) {
                CtExpression ctExpression;
                if (ctElement instanceof CtExpression && !(ctExpression = (CtExpression)ctElement).isImplicit() && ctExpression.getPosition().isValidPosition() && !MathReimplementation.this.checkHypot(ctExpression)) {
                    MathReimplementation.this.checkSqrt(ctExpression);
                }
                super.enter(ctElement);
            }

            public void visitCtIf(CtIf ctIf) {
                if (ctIf.isImplicit() || !ctIf.getPosition().isValidPosition() || ctIf.getThenStatement() == null) {
                    super.visitCtIf(ctIf);
                    return;
                }
                MathReimplementation.this.checkMaxMin(ctIf);
                super.visitCtIf(ctIf);
            }
        });
    }
}

