/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.api;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Map;
import java.util.function.Predicate;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtTypeReference;

@ExecutableCheck(reportedProblems={ProblemType.COLLECTION_IS_EMPTY_REIMPLEMENTED, ProblemType.STRING_IS_EMPTY_REIMPLEMENTED})
public class IsEmptyReimplementationCheck
extends IntegratedCheck {
    private void reportProblem(CtElement ctElement, String original, String suggestion, ProblemType problemType) {
        this.addLocalProblem(ctElement, (Translatable)new LocalizedMessage("suggest-replacement", Map.of("original", original, "suggestion", suggestion)), problemType);
    }

    private static boolean isTargetTypeEqualTo(CtInvocation<?> ctInvocation, Class<?> ctClass) {
        return ctInvocation.getTarget() != null && SpoonUtil.isTypeEqualTo(ctInvocation.getTarget().getType(), ctClass);
    }

    private static boolean isSizeCall(CtInvocation<?> ctInvocation) {
        CtExpression target = ctInvocation.getTarget();
        return target != null && target.getType().getTypeDeclaration() != null && target.getType().getTypeDeclaration().getMethod(ctInvocation.getFactory().Type().booleanPrimitiveType(), "isEmpty", new CtTypeReference[0]) != null && SpoonUtil.isSignatureEqualTo(ctInvocation.getExecutable(), Integer.TYPE, "size", new Class[0]);
    }

    private static boolean isLengthCall(CtInvocation<?> ctInvocation) {
        return IsEmptyReimplementationCheck.isTargetTypeEqualTo(ctInvocation, String.class) && SpoonUtil.isSignatureEqualTo(ctInvocation.getExecutable(), Integer.TYPE, "length", new Class[0]);
    }

    private static boolean isEqualsCall(CtInvocation<?> ctInvocation) {
        return IsEmptyReimplementationCheck.isTargetTypeEqualTo(ctInvocation, String.class) && SpoonUtil.isSignatureEqualTo(ctInvocation.getExecutable(), Boolean.TYPE, "equals", Object.class);
    }

    private static CtExpression<?> buildIsEmptySuggestion(CtExpression<?> target) {
        return target.getFactory().createInvocation(target.clone(), target.getType().getTypeDeclaration().getMethod("isEmpty", new CtTypeReference[0]).getReference().clone(), new CtExpression[0]);
    }

    private void checkIsEmptyReimplementation(CtExpression<?> target, CtBinaryOperator<?> ctBinaryOperator, ProblemType problemType) {
        CtLiteral ctLiteral;
        Predicate<CtExpression> isLiteral = expr -> expr instanceof CtLiteral;
        if (!SpoonUtil.isBoolean(ctBinaryOperator)) {
            return;
        }
        CtBinaryOperator<?> result = SpoonUtil.normalizeBy((left, right) -> isLiteral.test((CtExpression)left) && !isLiteral.test((CtExpression)right), ctBinaryOperator);
        Object object = result.getRightHandOperand();
        if (!(object instanceof CtLiteral) || !((object = (ctLiteral = (CtLiteral)object).getValue()) instanceof Number)) {
            return;
        }
        Number number = (Number)object;
        boolean isZero = number.doubleValue() == 0.0;
        boolean isOne = number.doubleValue() == 1.0;
        CtExpression<?> suggestion = IsEmptyReimplementationCheck.buildIsEmptySuggestion(target);
        switch (result.getKind()) {
            case EQ: 
            case LE: {
                if (!isZero) break;
                this.reportProblem((CtElement)ctBinaryOperator, ctBinaryOperator.prettyprint(), suggestion.prettyprint(), problemType);
                break;
            }
            case NE: {
                if (!isZero) break;
                this.reportProblem((CtElement)ctBinaryOperator, ctBinaryOperator.prettyprint(), SpoonUtil.negate(suggestion).prettyprint(), problemType);
                break;
            }
            case GE: {
                if (!isOne) break;
                this.reportProblem((CtElement)ctBinaryOperator, ctBinaryOperator.prettyprint(), SpoonUtil.negate(suggestion).prettyprint(), problemType);
            }
        }
    }

    private void checkEqualsCall(CtExpression<?> target, CtInvocation<?> ctInvocation, ProblemType problemType) {
        CtExpression argument = (CtExpression)ctInvocation.getArguments().get(0);
        if (SpoonUtil.isStringLiteral(SpoonUtil.resolveConstant(argument), "")) {
            this.reportProblem((CtElement)ctInvocation, ctInvocation.prettyprint(), IsEmptyReimplementationCheck.buildIsEmptySuggestion(target).prettyprint(), problemType);
        }
        if (SpoonUtil.isStringLiteral(SpoonUtil.resolveConstant(target), "")) {
            this.reportProblem((CtElement)ctInvocation, ctInvocation.prettyprint(), IsEmptyReimplementationCheck.buildIsEmptySuggestion(argument).prettyprint(), problemType);
        }
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtInvocation<?>>(){

            public void process(CtInvocation<?> ctInvocation) {
                CtElement ctElement;
                if (ctInvocation.isImplicit() || !ctInvocation.getPosition().isValidPosition()) {
                    return;
                }
                CtExpression target = ctInvocation.getTarget();
                if (target == null) {
                    return;
                }
                if (IsEmptyReimplementationCheck.isEqualsCall(ctInvocation)) {
                    IsEmptyReimplementationCheck.this.checkEqualsCall(target, ctInvocation, ProblemType.STRING_IS_EMPTY_REIMPLEMENTED);
                }
                if (!((ctElement = ctInvocation.getParent()) instanceof CtBinaryOperator)) {
                    return;
                }
                CtBinaryOperator ctBinaryOperator = (CtBinaryOperator)ctElement;
                if (IsEmptyReimplementationCheck.isLengthCall(ctInvocation)) {
                    IsEmptyReimplementationCheck.this.checkIsEmptyReimplementation(target, ctBinaryOperator, ProblemType.STRING_IS_EMPTY_REIMPLEMENTED);
                }
                if (IsEmptyReimplementationCheck.isSizeCall(ctInvocation)) {
                    IsEmptyReimplementationCheck.this.checkIsEmptyReimplementation(target, ctBinaryOperator, ProblemType.COLLECTION_IS_EMPTY_REIMPLEMENTED);
                }
            }
        });
    }
}

