/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.api;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Comparator;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeInformation;
import spoon.reflect.reference.CtTypeReference;

@ExecutableCheck(reportedProblems={ProblemType.IMPLEMENT_COMPARABLE})
public class ImplementComparable
extends IntegratedCheck {
    private static CtTypeReference<?> getInterface(CtTypeInformation ctType, Class<?> interfaceType) {
        return ctType.getSuperInterfaces().stream().filter(type -> SpoonUtil.isSubtypeOf(type, interfaceType)).findAny().orElse(null);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtClass<?>>(){

            public void process(CtClass<?> ctType) {
                if (ctType.isImplicit() || !ctType.getPosition().isValidPosition()) {
                    return;
                }
                CtTypeReference<?> comparator = ImplementComparable.getInterface(ctType, Comparator.class);
                if (comparator == null || comparator.getActualTypeArguments().size() != 1) {
                    return;
                }
                CtType compared = ((CtTypeReference)comparator.getActualTypeArguments().get(0)).getTypeDeclaration();
                if (ctType.equals((Object)compared)) {
                    ImplementComparable.this.addLocalProblem(ctType, new LocalizedMessage("implement-comparable", Map.of("name", compared.getSimpleName())), ProblemType.IMPLEMENT_COMPARABLE);
                }
            }
        });
    }
}

