/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core;

import de.firemage.autograder.core.CodePosition;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.Problem;
import de.firemage.autograder.core.ProblemImpl;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.file.SourcePath;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;

public class MultiInCodeProblem
extends ProblemImpl {
    public MultiInCodeProblem(Problem firstProblem, Collection<? extends Problem> otherProblems) {
        super(firstProblem.getCheck(), firstProblem.getPosition(), MultiInCodeProblem.makeExplanation(firstProblem, otherProblems), firstProblem.getProblemType());
    }

    private static Translatable makeExplanation(Problem first, Collection<? extends Problem> problems) {
        return bundle -> {
            Object message = first.getExplanation().format(bundle);
            if (!((String)message).endsWith(".")) {
                message = (String)message + ".";
            }
            return new LocalizedMessage("merged-problems", Map.of("message", message, "locations", MultiInCodeProblem.displayLocations(first.getPosition().file(), problems.stream().map(Problem::getPosition)))).format(bundle);
        };
    }

    private static String displayLocations(SourcePath firstFile, Stream<CodePosition> positions) {
        Map positionsByFile = positions.collect(Collectors.groupingBy(CodePosition::file, LinkedHashMap::new, Collectors.toList()));
        boolean withoutFilename = positionsByFile.size() == 1 && positionsByFile.containsKey(firstFile);
        StringJoiner joiner = new StringJoiner(", ");
        for (Map.Entry entry : positionsByFile.entrySet()) {
            SourcePath path = (SourcePath)entry.getKey();
            List filePositions = (List)entry.getValue();
            String lines = filePositions.stream().map(position -> "L%d".formatted(position.startLine())).collect(Collectors.joining(", "));
            if (filePositions.size() > 1 && !withoutFilename) {
                lines = "(%s)".formatted(lines);
            }
            if (withoutFilename) {
                joiner.add(lines);
                continue;
            }
            joiner.add("%s:%s".formatted(FilenameUtils.getBaseName((String)path.getName()), lines));
        }
        return joiner.toString();
    }
}

