/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core;

import de.firemage.autograder.core.LinterException;
import de.firemage.autograder.core.LinterStatus;
import de.firemage.autograder.core.Problem;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.check.Check;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.check.general.CopyPasteCheck;
import de.firemage.autograder.core.cpd.CPDLinter;
import de.firemage.autograder.core.errorprone.ErrorProneCheck;
import de.firemage.autograder.core.errorprone.ErrorProneLinter;
import de.firemage.autograder.core.errorprone.TempLocation;
import de.firemage.autograder.core.file.UploadedFile;
import de.firemage.autograder.core.integrated.IntegratedAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.parallel.AnalysisResult;
import de.firemage.autograder.core.parallel.AnalysisScheduler;
import de.firemage.autograder.core.pmd.PMDCheck;
import de.firemage.autograder.core.pmd.PMDLinter;
import de.firemage.autograder.core.spotbugs.SpotbugsCheck;
import de.firemage.autograder.core.spotbugs.SpotbugsLinter;
import fluent.bundle.FluentBundle;
import fluent.bundle.FluentResource;
import fluent.functions.FluentFunctionFactory;
import fluent.functions.icu.ICUFunctionFactory;
import fluent.syntax.parser.FTLParser;
import fluent.syntax.parser.FTLStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;

public final class Linter {
    private final int threads;
    private final TempLocation tempLocation;
    private final FluentBundle fluentBundle;
    private final boolean disableDynamicAnalysis;
    private final ClassLoader classLoader;
    private final int maxProblemsPerCheck;
    private final Predicate<Problem> isExcluded;
    private static final Collection<Class<?>> CHECKS = new LinkedHashSet(new Reflections("de.firemage.autograder.core.check", new Scanner[]{Scanners.TypesAnnotated}).getTypesAnnotatedWith(ExecutableCheck.class));

    private Linter(Locale locale, TempLocation tempLocation, int threads, boolean disableDynamicAnalysis, ClassLoader classLoader, int maxProblemsPerCheck, Predicate<Problem> isExcluded) {
        String filename = switch (locale.getLanguage()) {
            case "de" -> "/strings.de.ftl";
            case "en" -> "/strings.en.ftl";
            default -> throw new IllegalArgumentException("No translation available for the locale " + locale);
        };
        try {
            FluentResource resource = FTLParser.parse((FTLStream)FTLStream.of((String)new String(this.getClass().getResourceAsStream(filename).readAllBytes(), StandardCharsets.UTF_8)));
            this.fluentBundle = FluentBundle.builder((Locale)locale, (FluentFunctionFactory)ICUFunctionFactory.INSTANCE).addResource(resource).build();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.tempLocation = tempLocation;
        this.threads = threads;
        this.disableDynamicAnalysis = disableDynamicAnalysis;
        this.classLoader = classLoader;
        this.maxProblemsPerCheck = maxProblemsPerCheck;
        this.isExcluded = isExcluded;
    }

    public static Linter defaultLinter(Locale locale) {
        return Linter.builder(locale).build();
    }

    public static Builder builder(Locale locale) {
        return new Builder(locale);
    }

    public FluentBundle getFluentBundle() {
        return this.fluentBundle;
    }

    public List<Problem> checkFile(UploadedFile file, Path tests, List<ProblemType> problemsToReport, Consumer<LinterStatus> statusConsumer) throws LinterException, IOException {
        return this.checkFile(file, tests, problemsToReport, this.findChecksForProblemTypes(problemsToReport), statusConsumer);
    }

    public List<Problem> checkFile(UploadedFile file, Path tests, Collection<ProblemType> problemsToReport, Iterable<? extends Check> checks, Consumer<LinterStatus> statusConsumer) throws LinterException, IOException {
        AnalysisResult analysisResult;
        if (file == null) {
            return new ArrayList<Problem>();
        }
        ArrayList<PMDCheck> pmdChecks = new ArrayList<PMDCheck>();
        ArrayList<SpotbugsCheck> spotbugsChecks = new ArrayList<SpotbugsCheck>();
        ArrayList<CopyPasteCheck> cpdChecks = new ArrayList<CopyPasteCheck>();
        ArrayList<IntegratedCheck> integratedChecks = new ArrayList<IntegratedCheck>();
        ArrayList<ErrorProneCheck> errorProneChecks = new ArrayList<ErrorProneCheck>();
        for (Check check : checks) {
            if (check instanceof PMDCheck) {
                PMDCheck pmdCheck = (PMDCheck)check;
                pmdChecks.add(pmdCheck);
            } else if (check instanceof CopyPasteCheck) {
                CopyPasteCheck cpdCheck = (CopyPasteCheck)check;
                cpdChecks.add(cpdCheck);
            } else if (check instanceof SpotbugsCheck) {
                SpotbugsCheck spotbugsCheck = (SpotbugsCheck)check;
                spotbugsChecks.add(spotbugsCheck);
            } else if (check instanceof IntegratedCheck) {
                IntegratedCheck integratedCheck = (IntegratedCheck)check;
                integratedChecks.add(integratedCheck);
            }
            if (!(check instanceof ErrorProneCheck)) continue;
            ErrorProneCheck errorProneCheck = (ErrorProneCheck)check;
            errorProneChecks.add(errorProneCheck);
        }
        AnalysisScheduler scheduler = new AnalysisScheduler(this.threads, this.classLoader);
        if (!pmdChecks.isEmpty()) {
            scheduler.submitTask((s, reporter) -> {
                statusConsumer.accept(LinterStatus.RUNNING_PMD);
                reporter.reportProblems(new PMDLinter().lint(file, pmdChecks, this.classLoader));
            });
        }
        if (!cpdChecks.isEmpty()) {
            scheduler.submitTask((s, reporter) -> {
                statusConsumer.accept(LinterStatus.RUNNING_CPD);
                reporter.reportProblems(new CPDLinter().lint(file, cpdChecks));
            });
        }
        if (!spotbugsChecks.isEmpty()) {
            scheduler.submitTask((s, reporter) -> {
                statusConsumer.accept(LinterStatus.RUNNING_SPOTBUGS);
                reporter.reportProblems(new SpotbugsLinter().lint(file, file.getCompilationResult().jar(), spotbugsChecks));
            });
        }
        try (TempLocation tempLinterLocation = this.tempLocation.createTempDirectory("linter");){
            Path tmpLocation = tempLinterLocation.toPath();
            if (!integratedChecks.isEmpty()) {
                scheduler.submitTask((s, reporter) -> {
                    IntegratedAnalysis analysis = new IntegratedAnalysis(file, tmpLocation);
                    if (!this.disableDynamicAnalysis) {
                        analysis.runDynamicAnalysis(tests, statusConsumer);
                    }
                    analysis.lint(integratedChecks, statusConsumer, s);
                });
            }
            if (!errorProneChecks.isEmpty()) {
                scheduler.submitTask((s, reporter) -> {
                    statusConsumer.accept(LinterStatus.RUNNING_ERROR_PRONE);
                    reporter.reportProblems(new ErrorProneLinter().lint(file, tempLinterLocation, errorProneChecks));
                });
            }
            if ((analysisResult = scheduler.collectProblems()).failed()) {
                throw new LinterException(analysisResult.thrownException());
            }
        }
        List<Problem> unreducedProblems = analysisResult.problems();
        if (!problemsToReport.isEmpty()) {
            unreducedProblems = analysisResult.problems().stream().filter(problem -> problemsToReport.contains((Object)problem.getProblemType())).toList();
        }
        unreducedProblems = unreducedProblems.stream().filter(this.isExcluded.negate()).toList();
        return this.mergeProblems(unreducedProblems);
    }

    private List<Problem> mergeProblems(Collection<? extends Problem> unreducedProblems) {
        if (this.maxProblemsPerCheck == -1) {
            return new ArrayList<Problem>(unreducedProblems);
        }
        Map problems = unreducedProblems.stream().collect(Collectors.groupingBy(Problem::getCheck, LinkedHashMap::new, Collectors.toList()));
        ArrayList<Problem> result = new ArrayList<Problem>();
        for (Map.Entry entry : problems.entrySet()) {
            Check check = (Check)entry.getKey();
            List problemsForCheck = (List)entry.getValue();
            int targetNumberOfProblems = Math.min(this.maxProblemsPerCheck, ((Check)entry.getKey()).maximumProblems().orElse(this.maxProblemsPerCheck));
            if (problemsForCheck.size() > targetNumberOfProblems) {
                Map problemsByType = problemsForCheck.stream().collect(Collectors.groupingBy(Problem::getProblemType, LinkedHashMap::new, Collectors.toList()));
                problemsForCheck = problemsByType.values().stream().flatMap(list -> check.merge((List<Problem>)list, targetNumberOfProblems).stream()).collect(Collectors.toCollection(ArrayList::new));
            }
            result.addAll(problemsForCheck);
        }
        return result;
    }

    public String translateMessage(Translatable message) {
        String output = message.format(this.fluentBundle);
        if (output.startsWith("Unknown messageID '")) {
            throw new IllegalStateException(output);
        }
        return output;
    }

    public List<Check> findChecksForProblemTypes(Collection<ProblemType> problems) {
        return CHECKS.stream().filter(c -> this.isRequiredCheck(c.getAnnotation(ExecutableCheck.class), problems)).map(c -> {
            try {
                return (Check)c.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Failed to instantiate check " + c.getName(), e);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException(c.getName() + " does not inherit from Check");
            }
        }).toList();
    }

    private boolean isRequiredCheck(ExecutableCheck check, Collection<ProblemType> problems) {
        return check.enabled() && problems.stream().anyMatch(p -> List.of(check.reportedProblems()).contains(p));
    }

    public static class Builder {
        private final Locale locale;
        private TempLocation tempLocation;
        private int threads;
        private boolean disableDynamicAnalysis = true;
        private ClassLoader classLoader;
        private int maxProblemsPerCheck = -1;
        private Predicate<Problem> isExcluded;

        private Builder(Locale locale) {
            this.locale = locale;
            this.isExcluded = problem -> false;
        }

        public Builder tempLocation(TempLocation tempLocation) {
            this.tempLocation = tempLocation;
            return this;
        }

        public Builder threads(int threads) {
            this.threads = threads;
            return this;
        }

        public Builder maxProblemsPerCheck(int maxProblemsPerCheck) {
            this.maxProblemsPerCheck = maxProblemsPerCheck;
            return this;
        }

        public Builder enableDynamicAnalysis() {
            return this.enableDynamicAnalysis(true);
        }

        public Builder enableDynamicAnalysis(boolean shouldEnable) {
            this.disableDynamicAnalysis = !shouldEnable;
            return this;
        }

        public Builder classLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder exclude(Predicate<Problem> isExcluded) {
            this.isExcluded = isExcluded;
            return this;
        }

        public Linter build() {
            TempLocation tempLocation = this.tempLocation;
            if (tempLocation == null) {
                tempLocation = TempLocation.random();
            }
            return new Linter(this.locale, tempLocation, this.threads, this.disableDynamicAnalysis, this.classLoader, this.maxProblemsPerCheck, this.isExcluded);
        }
    }
}

