/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.visualize.dot;

import de.firemage.autograder.core.visualize.dot.DotEdge;
import de.firemage.autograder.core.visualize.dot.DotNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class DotGraph {
    private final String name;
    private final HashMap<String, DotNode> nodes;
    private final List<DotEdge> edges;

    public DotGraph(String name) {
        this.name = name;
        this.nodes = new HashMap();
        this.edges = new ArrayList<DotEdge>();
    }

    public DotNode getOrCreateNode(String name) {
        return this.nodes.computeIfAbsent(name, k -> new DotNode((String)k, null, (Map<String, String>)new HashMap<String, String>()));
    }

    public DotEdge addEdge(DotNode start, DotNode end) {
        DotEdge edge = new DotEdge(start, end, null, new HashMap<String, String>());
        this.edges.add(edge);
        return edge;
    }

    public String toDotString() {
        StringBuilder result = new StringBuilder();
        result.append("digraph \"%s\" {\n".formatted(this.name));
        result.append("  {\n    ").append(this.nodes.values().stream().map(DotNode::toDotString).collect(Collectors.joining("\n    "))).append("\n  }");
        result.append("\n  ");
        result.append(this.edges.stream().map(DotEdge::toDotString).collect(Collectors.joining("\n  ")));
        result.append("\n}");
        return result.toString();
    }

    public String toSvg() throws IOException, InterruptedException {
        String dotString = this.toDotString();
        Process graphviz = new ProcessBuilder("dot", "-Tsvg", "-q").start();
        graphviz.outputWriter().write(dotString);
        graphviz.outputWriter().newLine();
        graphviz.outputWriter().flush();
        graphviz.outputWriter().close();
        graphviz.waitFor(5L, TimeUnit.SECONDS);
        StringBuilder result = new StringBuilder();
        while (graphviz.inputReader().ready()) {
            result.append(graphviz.inputReader().readLine()).append(System.lineSeparator());
        }
        graphviz.destroy();
        if (!graphviz.waitFor(2L, TimeUnit.SECONDS)) {
            graphviz.destroyForcibly();
            throw new IOException("graphviz timeout");
        }
        return result.toString();
    }
}

