/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.spotbugs;

import de.firemage.autograder.core.Problem;
import de.firemage.autograder.core.file.SourceInfo;
import de.firemage.autograder.core.spotbugs.SpotbugsCheck;
import de.firemage.autograder.core.spotbugs.SpotbugsInCodeProblem;
import edu.umd.cs.findbugs.AbstractBugReporter;
import edu.umd.cs.findbugs.AnalysisError;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.annotations.Confidence;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;

public class InCodeBugReporter
extends AbstractBugReporter {
    private final BugCollection bugCollection;
    private final SourceInfo sourceInfo;

    public InCodeBugReporter(Project project, SourceInfo sourceInfo) {
        super.setPriorityThreshold(Confidence.LOW.getConfidenceValue());
        super.setRankThreshold(20);
        this.bugCollection = new SortedBugCollection(project);
        this.sourceInfo = sourceInfo;
    }

    protected void doReportBug(BugInstance bugInstance) {
        this.bugCollection.add(bugInstance);
    }

    public void reportAnalysisError(AnalysisError error) {
    }

    public void reportMissingClass(String string) {
    }

    public void finish() {
    }

    @CheckForNull
    public BugCollection getBugCollection() {
        return this.bugCollection;
    }

    public void observeClass(ClassDescriptor classDescriptor) {
    }

    public List<Problem> getProblems(List<SpotbugsCheck> checks) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        for (BugInstance bug : this.bugCollection.getCollection()) {
            for (SpotbugsCheck check : checks) {
                if (!check.getBug().equals(bug.getType())) continue;
                problems.add(new SpotbugsInCodeProblem(check, bug, this.sourceInfo));
            }
        }
        return problems;
    }
}

