/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.parallel;

import de.firemage.autograder.core.Problem;
import de.firemage.autograder.core.parallel.AnalysisResult;
import de.firemage.autograder.core.parallel.AnalysisScheduler;
import de.firemage.autograder.core.parallel.AnalysisTask;
import de.firemage.autograder.core.parallel.ProblemReporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class AnalysisThread {
    private final AnalysisScheduler scheduler;
    private final Thread thread;
    private final List<Problem> reportedProblems;
    private Exception thrownException;

    public AnalysisThread(AnalysisScheduler scheduler, int threadIndex) {
        this.scheduler = scheduler;
        this.reportedProblems = new ArrayList<Problem>();
        this.thread = new Thread(this::run, "Autograder-Analysis-Thread-" + threadIndex);
    }

    private void run() {
        if (this.scheduler.getClassLoader() != null) {
            Thread.currentThread().setContextClassLoader(this.scheduler.getClassLoader());
        }
        ProblemReporter reporter = new ProblemReporter(){

            @Override
            public void reportProblem(Problem problem) {
                AnalysisThread.this.reportedProblems.add(problem);
            }

            @Override
            public void reportProblems(Collection<Problem> problems) {
                AnalysisThread.this.reportedProblems.addAll(problems);
            }
        };
        try {
            Optional<AnalysisTask> task;
            while ((task = this.scheduler.getTask()).isPresent()) {
                try {
                    task.get().run(this.scheduler, reporter);
                }
                catch (Exception ex) {
                    this.scheduler.completeTask();
                    this.thrownException = ex;
                    return;
                }
                if (!this.scheduler.completeTask()) continue;
                return;
            }
            return;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            this.thrownException = ex;
            return;
        }
    }

    public void start() {
        this.thread.start();
    }

    public AnalysisResult join() throws InterruptedException {
        this.thread.join();
        if (this.thrownException == null) {
            return AnalysisResult.forSuccess(this.reportedProblems);
        }
        return AnalysisResult.forFailure(this.thrownException);
    }
}

