/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated.graph;

import de.firemage.autograder.core.CodeModel;
import de.firemage.autograder.core.integrated.graph.Usage;
import de.firemage.autograder.core.integrated.graph.UsageAccessField;
import de.firemage.autograder.core.integrated.graph.UsageCallMethod;
import de.firemage.autograder.core.integrated.graph.UsageCreateInstance;
import de.firemage.autograder.core.integrated.graph.UsageField;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.graph.DirectedMultigraph;
import org.jgrapht.nio.AttributeType;
import org.jgrapht.nio.DefaultAttribute;
import org.jgrapht.nio.dot.DOTExporter;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtTypeReference;

public class GraphBuilder {
    private final boolean includeJDK;

    public GraphBuilder(boolean includeJDK) {
        this.includeJDK = includeJDK;
    }

    public Graph<CtTypeReference<?>, Usage> buildGraph(CodeModel model) {
        DirectedMultigraph graph = new DirectedMultigraph(Usage.class);
        model.getModel().getAllTypes().forEach(arg_0 -> this.lambda$buildGraph$3((Graph)graph, arg_0));
        return graph;
    }

    private void createVertex(CtTypeReference<?> type, Graph<CtTypeReference<?>, Usage> graph) {
        if (this.includeType(type) && !graph.containsVertex(type)) {
            graph.addVertex(type);
        }
    }

    private void addMethodCall(CtTypeReference<?> start, CtMethod<?> method, Graph<CtTypeReference<?>, Usage> graph) {
        CtTypeReference target = method.getDeclaringType().getReference();
        if (this.includeType(start) && this.includeType(target) && !start.equals((Object)target)) {
            this.createVertex(target, graph);
            this.addEdge(start, target, new UsageCallMethod(start, target, method), graph);
        }
    }

    private void addField(CtTypeReference<?> start, CtField<?> field, Graph<CtTypeReference<?>, Usage> graph) {
        this.addReferenceViaField(start, field, field.getType(), 0, graph);
    }

    private void addReferenceViaField(CtTypeReference<?> start, CtField<?> field, CtTypeReference<?> type, int index, Graph<CtTypeReference<?>, Usage> graph) {
        if (this.includeType(start) && this.includeType(type) && !start.equals(type)) {
            this.createVertex(type, graph);
            this.addEdge(start, type, new UsageField(start, type, field, index), graph);
        }
        for (CtTypeReference parameter : type.getActualTypeArguments()) {
            this.addReferenceViaField(start, field, parameter, index + 1, graph);
        }
    }

    private void addInstanceCreation(CtTypeReference<?> start, CtConstructor<?> constructor, Graph<CtTypeReference<?>, Usage> graph) {
        CtTypeReference target = constructor.getDeclaringType().getReference();
        if (this.includeType(start) && this.includeType(target) && !start.equals((Object)target)) {
            this.createVertex(target, graph);
            this.addEdge(start, target, new UsageCreateInstance(start, target, constructor), graph);
        }
    }

    private void addFieldAccess(CtTypeReference<?> start, CtField<?> field, Graph<CtTypeReference<?>, Usage> graph) {
        CtTypeReference target = field.getDeclaringType().getReference();
        if (this.includeType(start) && this.includeType(target) && !start.equals((Object)target)) {
            this.createVertex(target, graph);
            this.addEdge(start, target, new UsageAccessField(start, target, field), graph);
        }
    }

    private void addEdge(CtTypeReference<?> start, CtTypeReference<?> end, Usage usage, Graph<CtTypeReference<?>, Usage> graph) {
        if (!graph.containsEdge((Object)usage)) {
            graph.addEdge(start, end, (Object)usage);
        }
    }

    private boolean includeType(CtTypeReference<?> type) {
        return !type.isPrimitive() && !type.isShadow() && type.getTypeDeclaration() != null && (this.includeJDK || !type.getQualifiedName().startsWith("java."));
    }

    public void exportToFile(Graph<CtTypeReference<?>, Usage> graph, String filename) {
        try {
            DOTExporter exporter = new DOTExporter();
            exporter.setVertexAttributeProvider(type -> Map.of("label", new DefaultAttribute((Object)type.getQualifiedName(), AttributeType.STRING)));
            exporter.setEdgeAttributeProvider(usage -> {
                if (usage instanceof UsageField) {
                    UsageField field = (UsageField)usage;
                    return Map.of("label", new DefaultAttribute((Object)(field.getField().getSimpleName() + "#" + field.getTypeParameterIndex()), AttributeType.STRING));
                }
                if (usage instanceof UsageCallMethod) {
                    UsageCallMethod method = (UsageCallMethod)usage;
                    return Map.of("label", new DefaultAttribute((Object)method.getMethod().getSignature(), AttributeType.STRING));
                }
                if (usage instanceof UsageCreateInstance) {
                    UsageCreateInstance constructor = (UsageCreateInstance)usage;
                    String signature = constructor.getConstructor().getSignature();
                    return Map.of("label", new DefaultAttribute((Object)("new " + signature.substring(signature.indexOf(constructor.getConstructor().getDeclaringType().getSimpleName()))), AttributeType.STRING));
                }
                if (usage instanceof UsageAccessField) {
                    UsageAccessField field = (UsageAccessField)usage;
                    return Map.of("label", new DefaultAttribute((Object)("->" + field.getField().getSimpleName()), AttributeType.STRING));
                }
                throw new IllegalStateException();
            });
            FileWriter writer = new FileWriter(filename);
            exporter.exportGraph(graph, (Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private /* synthetic */ void lambda$buildGraph$3(Graph graph, CtType type) {
        if (type.getRoleInParent() == CtRole.TYPE_PARAMETER) {
            return;
        }
        this.createVertex(type.getReference(), graph);
        for (CtField field : type.getFields()) {
            this.addField(type.getReference(), field, graph);
        }
        type.filterChildren(CtInvocation.class::isInstance).forEach(i -> {
            CtExecutable executable = i.getExecutable().getExecutableDeclaration();
            if (executable instanceof CtMethod) {
                CtMethod method = (CtMethod)executable;
                this.addMethodCall(type.getReference(), method, graph);
            } else if (executable instanceof CtConstructor) {
                CtConstructor constructor = (CtConstructor)executable;
                this.addInstanceCreation(type.getReference(), constructor, graph);
            } else {
                throw new IllegalStateException(executable.getClass().getSimpleName());
            }
        });
        type.filterChildren(CtConstructorCall.class::isInstance).forEach(c -> {
            CtExecutable executable = c.getExecutable().getExecutableDeclaration();
            if (!(executable instanceof CtConstructor)) {
                throw new IllegalStateException(executable.getClass().getSimpleName());
            }
            CtConstructor constructor = (CtConstructor)executable;
            this.addInstanceCreation(type.getReference(), constructor, graph);
        });
        type.filterChildren(CtFieldAccess.class::isInstance).forEach(a -> {
            CtField field = a.getVariable().getFieldDeclaration();
            if (field == null) {
                return;
            }
            this.addFieldAccess(type.getReference(), field, graph);
        });
    }
}

