/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated.evaluator.fold;

import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.evaluator.fold.Fold;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import spoon.reflect.code.CtExpression;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;

public final class RemoveRedundantCasts
implements Fold {
    private static final List<Class<?>> HIERARCHY = List.of(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);
    private static final List<Class<?>> CHARACTER_IMPLICIT_WIDENING = List.of(Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);

    private RemoveRedundantCasts() {
    }

    public static Fold create() {
        return new RemoveRedundantCasts();
    }

    private static boolean canBeImplicitlyCastTo(CtTypeReference<?> from, CtTypeReference<?> to) {
        if (from.equals(to)) {
            return true;
        }
        if (from.unbox().equals(to.unbox())) {
            return true;
        }
        CtTypeReference unboxedFrom = from.unbox();
        if (unboxedFrom.isPrimitive() && to.isPrimitive()) {
            if (SpoonUtil.isTypeEqualTo(unboxedFrom, Character.TYPE)) {
                return CHARACTER_IMPLICIT_WIDENING.contains(to.getActualClass());
            }
            int indexFrom = HIERARCHY.indexOf(unboxedFrom.getActualClass());
            int indexTo = HIERARCHY.indexOf(to.getActualClass());
            return indexFrom != -1 && indexTo != -1 && indexFrom <= indexTo;
        }
        if (to instanceof CtTypeParameterReference) {
            return false;
        }
        return to.isSubtypeOf(from);
    }

    private static boolean isBoxedType(CtTypeReference<?> ctTypeReference) {
        return ctTypeReference.unbox().isPrimitive() && !ctTypeReference.equals((Object)ctTypeReference.unbox());
    }

    public static <T> CtExpression<T> removeRedundantCasts(CtExpression<T> ctExpression) {
        CtTypeReference originalType = ctExpression.getType();
        ArrayList typeCasts = new ArrayList(ctExpression.getTypeCasts());
        Collections.reverse(typeCasts);
        CtTypeReference currentType = originalType;
        ArrayList<CtTypeReference> newCasts = new ArrayList<CtTypeReference>();
        for (int i = 0; i < typeCasts.size(); ++i) {
            CtTypeReference newType = (CtTypeReference)typeCasts.get(i);
            CtTypeReference nextType = null;
            if (i + 1 < typeCasts.size()) {
                nextType = (CtTypeReference)typeCasts.get(i + 1);
            }
            if (nextType != null && RemoveRedundantCasts.isBoxedType(nextType) && !currentType.equals(nextType.unbox())) {
                newCasts.add(newType);
                currentType = newType;
                continue;
            }
            if (RemoveRedundantCasts.canBeImplicitlyCastTo(currentType, newType) || nextType != null && !RemoveRedundantCasts.canBeImplicitlyCastTo(currentType, nextType)) continue;
            newCasts.add(newType);
            currentType = newType;
        }
        CtTypeReference<?> originalExpressionType = SpoonUtil.getExpressionType(ctExpression);
        CtTypeReference newExpressionType = ctExpression.getType();
        if (!newCasts.isEmpty()) {
            newExpressionType = (CtTypeReference)newCasts.get(newCasts.size() - 1);
        }
        if (!originalExpressionType.equals((Object)newExpressionType)) {
            CtTypeReference preservingTypeCast = originalExpressionType.clone();
            preservingTypeCast.putMetadata("implicit", (Object)"true");
            newCasts.add(preservingTypeCast);
        }
        Collections.reverse(newCasts);
        ctExpression.setTypeCasts(newCasts);
        return ctExpression;
    }

    @Override
    public <T> CtExpression<T> foldCtExpression(CtExpression<T> ctExpression) {
        return RemoveRedundantCasts.removeRedundantCasts(ctExpression);
    }
}

