/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated.evaluator.fold;

import de.firemage.autograder.core.integrated.evaluator.OperatorHelper;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.reference.CtTypeReference;

public final class FoldUtils {
    private FoldUtils() {
    }

    public static Number convert(CtTypeReference<?> type, Number number) {
        CtTypeReference targetType = type.unbox();
        if (targetType.getActualClass() == Integer.TYPE) {
            return number.intValue();
        }
        if (targetType.getActualClass() == Byte.TYPE) {
            return number.byteValue();
        }
        if (targetType.getActualClass() == Long.TYPE) {
            return number.longValue();
        }
        if (targetType.getActualClass() == Float.TYPE) {
            return Float.valueOf(number.floatValue());
        }
        if (targetType.getActualClass() == Short.TYPE) {
            return number.shortValue();
        }
        if (targetType.getActualClass() == Double.TYPE) {
            return number.doubleValue();
        }
        return number;
    }

    private static <T> CtExpression<T> inferTypeIfNeeded(CtExpression<T> ctExpression) {
        CtUnaryOperator ctUnaryOperator;
        CtBinaryOperator ctBinaryOperator;
        CtExpression result = ctExpression.clone();
        if (result instanceof CtBinaryOperator && (ctBinaryOperator = (CtBinaryOperator)result).getType() == null) {
            ctBinaryOperator.setType(FoldUtils.inferType(ctBinaryOperator));
        } else if (result instanceof CtUnaryOperator && (ctUnaryOperator = (CtUnaryOperator)result).getType() == null) {
            ctUnaryOperator.setType(FoldUtils.inferType(ctUnaryOperator));
        }
        return result;
    }

    public static CtTypeReference<?> inferType(CtBinaryOperator<?> ctBinaryOperator) {
        return switch (ctBinaryOperator.getKind()) {
            default -> throw new IncompatibleClassChangeError();
            case BinaryOperatorKind.AND, BinaryOperatorKind.OR, BinaryOperatorKind.INSTANCEOF, BinaryOperatorKind.EQ, BinaryOperatorKind.NE, BinaryOperatorKind.LT, BinaryOperatorKind.LE, BinaryOperatorKind.GT, BinaryOperatorKind.GE -> ctBinaryOperator.getFactory().Type().booleanPrimitiveType();
            case BinaryOperatorKind.SL, BinaryOperatorKind.SR, BinaryOperatorKind.USR, BinaryOperatorKind.MUL, BinaryOperatorKind.DIV, BinaryOperatorKind.MOD, BinaryOperatorKind.MINUS, BinaryOperatorKind.PLUS, BinaryOperatorKind.BITAND, BinaryOperatorKind.BITXOR, BinaryOperatorKind.BITOR -> OperatorHelper.getPromotedType(ctBinaryOperator.getKind(), FoldUtils.inferTypeIfNeeded(ctBinaryOperator.getLeftHandOperand()), FoldUtils.inferTypeIfNeeded(ctBinaryOperator.getRightHandOperand())).orElseThrow();
        };
    }

    public static CtTypeReference<?> inferType(CtUnaryOperator<?> ctUnaryOperator) {
        return OperatorHelper.getPromotedType(ctUnaryOperator.getKind(), FoldUtils.inferTypeIfNeeded(ctUnaryOperator.getOperand())).orElseThrow();
    }
}

