/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated.evaluator.fold;

import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.evaluator.Evaluator;
import de.firemage.autograder.core.integrated.evaluator.fold.Fold;
import de.firemage.autograder.core.integrated.evaluator.fold.PromoteOperands;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.eval.PartialEvaluator;
import spoon.reflect.factory.Factory;

public final class EvaluatePartialLiteralOperations
implements Fold {
    private final PartialEvaluator evaluator = new Evaluator(PromoteOperands.create((operator, ctExpression) -> true, (operator, ctExpression) -> true));

    private EvaluatePartialLiteralOperations() {
    }

    public static Fold create() {
        return new EvaluatePartialLiteralOperations();
    }

    @Override
    public <T> CtExpression<T> foldCtBinaryOperator(CtBinaryOperator<T> ctBinaryOperator) {
        CtExpression ctExpression;
        CtBinaryOperator promotedOperator = (CtBinaryOperator)this.evaluator.evaluate(ctBinaryOperator);
        CtExpression rightExpression = promotedOperator.getRightHandOperand();
        if (!(promotedOperator.getLeftHandOperand() instanceof CtLiteral) && promotedOperator.getRightHandOperand() instanceof CtLiteral) {
            promotedOperator = SpoonUtil.swapCtBinaryOperator(promotedOperator);
        }
        if (!((ctExpression = promotedOperator.getLeftHandOperand()) instanceof CtLiteral)) {
            return ctBinaryOperator;
        }
        CtLiteral ctLiteral = (CtLiteral)ctExpression;
        CtExpression ctExpression2 = promotedOperator.getRightHandOperand();
        Factory factory = ctBinaryOperator.getFactory();
        boolean isLiteralValueTrue = Boolean.TRUE.equals(ctLiteral.getValue());
        CtLiteral trueLiteral = factory.createLiteral((Object)true);
        CtLiteral falseLiteral = factory.createLiteral((Object)false);
        return switch (promotedOperator.getKind()) {
            case BinaryOperatorKind.AND -> {
                if (isLiteralValueTrue) {
                    yield ctExpression2;
                }
                yield falseLiteral;
            }
            case BinaryOperatorKind.OR -> {
                if (isLiteralValueTrue) {
                    yield trueLiteral;
                }
                yield ctExpression2;
            }
            case BinaryOperatorKind.EQ -> {
                if (ctLiteral.getValue() instanceof Boolean && isLiteralValueTrue) {
                    yield ctExpression2;
                }
                yield ctBinaryOperator;
            }
            case BinaryOperatorKind.DIV -> {
                Number number;
                CtLiteral literal;
                Object var12_14;
                if (rightExpression instanceof CtLiteral && (var12_14 = (literal = (CtLiteral)rightExpression).getValue()) instanceof Number && (number = (Number)var12_14).doubleValue() == 1.0) {
                    yield ctExpression2;
                }
                yield ctBinaryOperator;
            }
            case BinaryOperatorKind.PLUS -> {
                Number number;
                Object number = ctLiteral.getValue();
                if (number instanceof Number && (number = (Number)number).doubleValue() == 0.0) {
                    yield ctExpression2;
                }
                yield ctBinaryOperator;
            }
            case BinaryOperatorKind.MUL -> {
                Number number;
                Object number = ctLiteral.getValue();
                if (number instanceof Number && (number = (Number)number).doubleValue() == 0.0) {
                    yield ctLiteral;
                }
                number = ctLiteral.getValue();
                if (number instanceof Number && (number = (Number)number).doubleValue() == 1.0) {
                    yield ctExpression2;
                }
                yield ctBinaryOperator;
            }
            case BinaryOperatorKind.MINUS -> {
                Number number;
                CtLiteral literal;
                Object var12_15;
                if (rightExpression instanceof CtLiteral && (var12_15 = (literal = (CtLiteral)rightExpression).getValue()) instanceof Number && (number = (Number)var12_15).doubleValue() == 0.0) {
                    yield ctExpression2;
                }
                yield ctBinaryOperator;
            }
            default -> ctBinaryOperator;
        };
    }
}

