/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated.evaluator.fold;

import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.evaluator.fold.Fold;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.reference.CtTypeReference;

public final class ApplyCasts
implements Fold {
    private final Predicate<? super CtExpression<?>> shouldApply;

    private ApplyCasts(Predicate<? super CtExpression<?>> shouldApply) {
        this.shouldApply = shouldApply;
    }

    public static Fold onLiterals() {
        return new ApplyCasts(ctExpression -> ctExpression instanceof CtLiteral);
    }

    public <T> CtLiteral<T> foldCtLiteral(CtLiteral<T> ctLiteral) {
        Object result = ctLiteral;
        if (!this.shouldApply.test((CtExpression<?>)ctLiteral)) {
            return result;
        }
        ArrayList casts = new ArrayList(ctLiteral.getTypeCasts());
        Collections.reverse(casts);
        ctLiteral.setTypeCasts(new ArrayList());
        for (CtTypeReference cast : casts) {
            result = SpoonUtil.castLiteral(cast, result);
        }
        return result;
    }
}

