/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated.effects;

import de.firemage.autograder.core.integrated.effects.AssignmentEffect;
import de.firemage.autograder.core.integrated.effects.Effect;
import java.util.Optional;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.reference.CtVariableReference;

public class AssignmentStatement
implements AssignmentEffect {
    private final CtAssignment<?, ?> ctAssignment;
    private final Optional<CtExpression<?>> value;

    private AssignmentStatement(CtAssignment<?, ?> ctAssignment) {
        this.ctAssignment = ctAssignment;
        this.value = Optional.ofNullable(ctAssignment.getAssignment());
    }

    public static Optional<Effect> of(CtStatement ctStatement) {
        CtAssignment ctAssignment;
        if (ctStatement instanceof CtAssignment && (ctAssignment = (CtAssignment)ctStatement).getAssigned() instanceof CtVariableWrite) {
            return Optional.of(new AssignmentStatement(ctAssignment));
        }
        return Optional.empty();
    }

    @Override
    public CtStatement ctStatement() {
        return this.ctAssignment;
    }

    @Override
    public Optional<CtExpression<?>> value() {
        return this.value;
    }

    @Override
    public CtVariableReference<?> target() {
        return ((CtVariableWrite)this.ctAssignment.getAssigned()).getVariable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSameEffect(Effect other) {
        if (!(other instanceof AssignmentEffect)) return false;
        AssignmentEffect otherAssignment = (AssignmentEffect)other;
        if (!this.target().equals(otherAssignment.target())) return false;
        return true;
    }
}

