/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated;

import de.firemage.autograder.core.integrated.effects.AssignmentStatement;
import de.firemage.autograder.core.integrated.effects.Effect;
import de.firemage.autograder.core.integrated.effects.TerminalEffect;
import de.firemage.autograder.core.integrated.effects.TerminalStatement;
import de.firemage.autograder.core.integrated.evaluator.Evaluator;
import de.firemage.autograder.core.integrated.evaluator.fold.FoldUtils;
import de.firemage.autograder.core.integrated.evaluator.fold.InferOperatorTypes;
import de.firemage.autograder.core.integrated.evaluator.fold.InlineVariableRead;
import de.firemage.autograder.core.integrated.evaluator.fold.RemoveRedundantCasts;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.utils.FileNameUtils;
import spoon.reflect.CtModel;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtJavaDoc;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtTypePattern;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.code.LiteralBase;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.cu.position.CompoundSourcePosition;
import spoon.reflect.declaration.CtCompilationUnit;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.TypeFactory;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.CompositeFilter;
import spoon.reflect.visitor.filter.DirectReferenceFilter;
import spoon.reflect.visitor.filter.FilteringOperator;
import spoon.reflect.visitor.filter.OverridingMethodFilter;
import spoon.reflect.visitor.filter.TypeFilter;

public final class SpoonUtil {
    private static final Filter<CtElement> EXPLICIT_ELEMENT_FILTER = ctElement -> !ctElement.isImplicit();

    private SpoonUtil() {
    }

    public static boolean isInJunitTest() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(element -> element.getClassName().startsWith("org.junit."));
    }

    public static boolean isString(CtTypeReference<?> type) {
        return SpoonUtil.isTypeEqualTo(type, String.class);
    }

    public static Optional<CtTypeReference<?>> isToStringCall(CtExpression<?> expression) {
        CtInvocation invocation;
        if (!SpoonUtil.isString(expression.getType())) {
            return Optional.empty();
        }
        if (expression instanceof CtInvocation && SpoonUtil.isSignatureEqualTo((invocation = (CtInvocation)expression).getExecutable(), String.class, "toString", new Class[0])) {
            return Optional.of(invocation.getTarget().getType());
        }
        return Optional.empty();
    }

    public static boolean isStringLiteral(CtExpression<?> expression, String value) {
        CtLiteral literal;
        return expression instanceof CtLiteral && (literal = (CtLiteral)expression).getValue() != null && literal.getValue().equals(value);
    }

    public static boolean isNullLiteral(CtExpression<?> expression) {
        CtLiteral literal;
        CtExpression<?> ctExpression = SpoonUtil.resolveConstant(expression);
        return ctExpression instanceof CtLiteral && (literal = (CtLiteral)ctExpression).getValue() == null;
    }

    public static boolean isIntegerLiteral(CtExpression<?> expression, int value) {
        CtLiteral literal;
        return expression instanceof CtLiteral && (literal = (CtLiteral)expression).getValue().equals(value);
    }

    public static boolean isBoolean(CtTypedElement<?> ctTypedElement) {
        CtTypeReference ctTypeReference = ctTypedElement.getType();
        return ctTypeReference != null && SpoonUtil.isTypeEqualTo(ctTypeReference, Boolean.TYPE, Boolean.class);
    }

    public static Optional<Boolean> tryGetBooleanLiteral(CtExpression<?> expression) {
        CtLiteral literal;
        CtExpression<?> ctExpression = SpoonUtil.resolveConstant(expression);
        if (ctExpression instanceof CtLiteral && (literal = (CtLiteral)ctExpression).getValue() != null && SpoonUtil.isBoolean(literal)) {
            return Optional.of((Boolean)literal.getValue());
        }
        return Optional.empty();
    }

    public static Optional<String> tryGetStringLiteral(CtExpression<?> expression) {
        CtLiteral literal;
        CtExpression<?> ctExpression = SpoonUtil.resolveConstant(expression);
        if (ctExpression instanceof CtLiteral && (literal = (CtLiteral)ctExpression).getValue() != null && SpoonUtil.isTypeEqualTo(literal.getType(), String.class)) {
            return Optional.of((String)literal.getValue());
        }
        return Optional.empty();
    }

    public static boolean areLiteralsEqual(CtLiteral<?> left, CtLiteral<?> right) {
        Number valLeft;
        Object object;
        block15: {
            block14: {
                if (left == null && right == null) {
                    return true;
                }
                if (left == null || right == null) {
                    return false;
                }
                if (left.getValue() == null) {
                    return right.getValue() == null;
                }
                if (right.getValue() == null) {
                    return false;
                }
                Object object2 = left.getValue();
                if (object2 instanceof Character) {
                    Character l = (Character)object2;
                    object2 = right.getValue();
                    if (object2 instanceof Character) {
                        Character r = (Character)object2;
                        return l.equals(r);
                    }
                }
                if ((object2 = left.getValue()) instanceof Number) {
                    Number l = (Number)object2;
                    object2 = right.getValue();
                    if (object2 instanceof Character) {
                        Character r = (Character)object2;
                        return l.intValue() == r.charValue();
                    }
                }
                if ((object2 = left.getValue()) instanceof Character) {
                    Character l = (Character)object2;
                    object2 = right.getValue();
                    if (object2 instanceof Number) {
                        Number r = (Number)object2;
                        return l.charValue() == r.intValue();
                    }
                }
                if (!((object = left.getValue()) instanceof Number)) break block14;
                valLeft = (Number)object;
                object = right.getValue();
                if (object instanceof Number) break block15;
            }
            return left.getValue() == right.getValue() || left.getValue().equals(right.getValue());
        }
        Number valRight = (Number)object;
        if (valLeft instanceof Float || valLeft instanceof Double || valRight instanceof Float || valRight instanceof Double) {
            return valLeft.doubleValue() == valRight.doubleValue();
        }
        return valLeft.longValue() == valRight.longValue();
    }

    public static <T> CtLiteral<T> makeLiteralNumber(CtTypeReference<T> ctTypeReference, Number number) {
        Number value = FoldUtils.convert(ctTypeReference, number);
        return SpoonUtil.makeLiteral(ctTypeReference, value);
    }

    public static <T> CtLiteral<T> makeLiteral(CtTypeReference<T> ctTypeReference, T value) {
        CtLiteral literal = ctTypeReference.getFactory().createLiteral();
        literal.setType(ctTypeReference.clone());
        literal.setValue(value);
        return literal;
    }

    public static List<CtExpression<?>> getElementsOfExpression(CtExpression<?> ctExpression) {
        CtExecutableReference ctExecutableReference;
        CtInvocation ctInvocation;
        Stream<CtTypeReference> supportedCollections = Stream.of(List.class, Set.class, Collection.class).map(e -> ctExpression.getFactory().Type().createReference(e));
        ArrayList result = new ArrayList();
        CtTypeReference expressionType = ctExpression.getType();
        if (supportedCollections.noneMatch(ty -> ty.equals(expressionType) || expressionType.isSubtypeOf(ty))) {
            return result;
        }
        if (ctExpression instanceof CtInvocation && (ctInvocation = (CtInvocation)ctExpression).getTarget() instanceof CtTypeAccess && (ctExecutableReference = ctInvocation.getExecutable()).getSimpleName().equals("of")) {
            result.addAll(ctInvocation.getArguments());
        }
        return result;
    }

    private static List<CtStatement> getEffectiveStatements(Collection<? extends CtStatement> statements) {
        return statements.stream().flatMap(ctStatement -> {
            if (ctStatement instanceof CtStatementList) {
                CtStatementList ctStatementList = (CtStatementList)ctStatement;
                return SpoonUtil.getEffectiveStatements(ctStatementList.getStatements()).stream();
            }
            return Stream.of(ctStatement);
        }).filter(statement -> !(statement instanceof CtComment)).toList();
    }

    public static <T> CtLiteral<T> minimumValue(CtLiteral<T> ctLiteral) {
        CtLiteral result = ctLiteral.getFactory().createLiteral();
        result.setBase(LiteralBase.DECIMAL);
        result.setType(ctLiteral.getType().clone());
        Object value = ctLiteral.getValue();
        Map minimumValueMapping = Map.ofEntries(Map.entry(Byte.TYPE, (byte)-128), Map.entry(Byte.class, (byte)-128), Map.entry(Short.TYPE, (short)Short.MIN_VALUE), Map.entry(Short.class, (short)Short.MIN_VALUE), Map.entry(Integer.TYPE, Integer.MIN_VALUE), Map.entry(Integer.class, Integer.MIN_VALUE), Map.entry(Long.TYPE, Long.MIN_VALUE), Map.entry(Long.class, Long.MIN_VALUE), Map.entry(Float.TYPE, Float.valueOf(Float.MIN_VALUE)), Map.entry(Float.class, Float.valueOf(Float.MIN_VALUE)), Map.entry(Double.TYPE, Double.MIN_VALUE), Map.entry(Double.class, Double.MIN_VALUE), Map.entry(Boolean.TYPE, false), Map.entry(Boolean.class, false), Map.entry(Character.TYPE, Character.valueOf('\u0000')), Map.entry(Character.class, Character.valueOf('\u0000')));
        result.setValue(minimumValueMapping.get(value.getClass()));
        return result;
    }

    public static <T> CtLiteral<T> maximumValue(CtLiteral<T> ctLiteral) {
        CtLiteral result = ctLiteral.getFactory().createLiteral();
        result.setBase(LiteralBase.DECIMAL);
        result.setType(ctLiteral.getType().clone());
        Object value = ctLiteral.getValue();
        Map maximumValueMapping = Map.ofEntries(Map.entry(Byte.TYPE, (byte)127), Map.entry(Byte.class, (byte)127), Map.entry(Short.TYPE, (short)Short.MAX_VALUE), Map.entry(Short.class, (short)Short.MAX_VALUE), Map.entry(Integer.TYPE, Integer.MAX_VALUE), Map.entry(Integer.class, Integer.MAX_VALUE), Map.entry(Long.TYPE, Long.MAX_VALUE), Map.entry(Long.class, Long.MAX_VALUE), Map.entry(Float.TYPE, Float.valueOf(Float.MAX_VALUE)), Map.entry(Float.class, Float.valueOf(Float.MAX_VALUE)), Map.entry(Double.TYPE, Double.MAX_VALUE), Map.entry(Double.class, Double.MAX_VALUE), Map.entry(Boolean.TYPE, true), Map.entry(Boolean.class, true), Map.entry(Character.TYPE, Character.valueOf('\uffff')), Map.entry(Character.class, Character.valueOf('\uffff')));
        result.setValue(maximumValueMapping.get(value.getClass()));
        return result;
    }

    private static <T> CtBinaryOperator<T> normalize(CtBinaryOperator<T> ctBinaryOperator) {
        CtLiteral ctLiteral;
        if (!Set.of(BinaryOperatorKind.LT, BinaryOperatorKind.GT).contains(ctBinaryOperator.getKind()) || !ctBinaryOperator.getRightHandOperand().getType().isPrimitive()) {
            return ctBinaryOperator;
        }
        CtLiteral step = ctBinaryOperator.getFactory().Core().createLiteral();
        Predicate<CtTypeReference> isCharacter = ty -> SpoonUtil.isTypeEqualTo(ty, Character.TYPE, Character.class);
        if (isCharacter.test(ctBinaryOperator.getRightHandOperand().getType())) {
            step.setValue((Object)Character.valueOf('\u0001'));
            step.setType(ctBinaryOperator.getFactory().Type().characterPrimitiveType());
        } else {
            step.setValue((Object)FoldUtils.convert(ctBinaryOperator.getRightHandOperand().getType(), ((Number)1).doubleValue()));
            step.setType(ctBinaryOperator.getRightHandOperand().getType());
        }
        CtBinaryOperator result = ctBinaryOperator.clone();
        if (ctBinaryOperator.getKind() == BinaryOperatorKind.LT) {
            result.setKind(BinaryOperatorKind.LE);
            result.setRightHandOperand(SpoonUtil.createBinaryOperator(ctBinaryOperator.getRightHandOperand(), step, BinaryOperatorKind.MINUS));
        } else if (ctBinaryOperator.getKind() == BinaryOperatorKind.GT) {
            result.setKind(BinaryOperatorKind.GE);
            result.setRightHandOperand(SpoonUtil.createBinaryOperator(ctBinaryOperator.getRightHandOperand(), step, BinaryOperatorKind.PLUS));
        }
        result.setLeftHandOperand(SpoonUtil.resolveCtExpression(result.getLeftHandOperand()));
        CtExpression ctExpression = result.getLeftHandOperand();
        if (ctExpression instanceof CtLiteral) {
            ctLiteral = (CtLiteral)ctExpression;
            result.setLeftHandOperand(SpoonUtil.castLiteral(SpoonUtil.getExpressionType(ctBinaryOperator.getLeftHandOperand()), ctLiteral));
        }
        result.setRightHandOperand(SpoonUtil.resolveCtExpression(result.getRightHandOperand()));
        ctExpression = result.getRightHandOperand();
        if (ctExpression instanceof CtLiteral) {
            ctLiteral = (CtLiteral)ctExpression;
            result.setRightHandOperand(SpoonUtil.castLiteral(SpoonUtil.getExpressionType(ctBinaryOperator.getRightHandOperand()), ctLiteral));
        }
        return result;
    }

    public static <T> CtBinaryOperator<T> createBinaryOperator(CtExpression<?> leftHandOperand, CtExpression<?> rightHandOperand, BinaryOperatorKind operatorKind) {
        CtBinaryOperator ctBinaryOperator;
        Factory factory = leftHandOperand.getFactory();
        if (factory == null) {
            factory = rightHandOperand.getFactory();
        }
        if ((ctBinaryOperator = factory.createBinaryOperator(leftHandOperand.clone(), rightHandOperand.clone(), operatorKind)).getType() == null) {
            ctBinaryOperator.setType(FoldUtils.inferType(ctBinaryOperator));
        }
        return ctBinaryOperator;
    }

    public static <T> CtUnaryOperator<T> createUnaryOperator(UnaryOperatorKind operatorKind, CtExpression<?> ctExpression) {
        CtUnaryOperator ctUnaryOperator = ctExpression.getFactory().createUnaryOperator();
        ctUnaryOperator.setOperand(ctExpression.clone());
        ctUnaryOperator.setKind(operatorKind);
        if (ctUnaryOperator.getType() == null) {
            ctUnaryOperator.setType(FoldUtils.inferType(ctUnaryOperator));
        }
        return ctUnaryOperator;
    }

    public static <T> CtBinaryOperator<T> swapCtBinaryOperator(CtBinaryOperator<T> ctBinaryOperator) {
        CtBinaryOperator result = ctBinaryOperator.clone();
        CtExpression left = result.getLeftHandOperand();
        CtExpression right = result.getRightHandOperand();
        result.setKind(switch (ctBinaryOperator.getKind()) {
            case BinaryOperatorKind.LT -> BinaryOperatorKind.GT;
            case BinaryOperatorKind.LE -> BinaryOperatorKind.GE;
            case BinaryOperatorKind.GE -> BinaryOperatorKind.LE;
            case BinaryOperatorKind.GT -> BinaryOperatorKind.LT;
            default -> ctBinaryOperator.getKind();
        });
        result.setLeftHandOperand(right);
        result.setRightHandOperand(left);
        return result;
    }

    public static <T> CtExpression<T> resolveConstant(CtExpression<T> ctExpression) {
        if (ctExpression == null) {
            return null;
        }
        Evaluator evaluator = new Evaluator(InferOperatorTypes.create(), InlineVariableRead.create());
        return (CtExpression)evaluator.evaluate((CtElement)ctExpression);
    }

    public static <T> CtBinaryOperator<T> normalizeBy(BiPredicate<? super CtExpression<?>, ? super CtExpression<?>> shouldSwap, CtBinaryOperator<T> ctBinaryOperator) {
        CtExpression<T> left = SpoonUtil.resolveConstant(ctBinaryOperator.getLeftHandOperand());
        CtExpression<T> right = SpoonUtil.resolveConstant(ctBinaryOperator.getRightHandOperand());
        BinaryOperatorKind operator = ctBinaryOperator.getKind();
        CtBinaryOperator<T> result = ctBinaryOperator.clone();
        result.setKind(operator);
        result.setLeftHandOperand(left.clone());
        result.setRightHandOperand(right.clone());
        if (shouldSwap.test(left, right)) {
            result = SpoonUtil.swapCtBinaryOperator(result);
        }
        return SpoonUtil.normalize(result);
    }

    public static <T> CtExpression<T> negate(CtExpression<T> ctExpression) {
        CtUnaryOperator ctUnaryOperator;
        if (ctExpression instanceof CtUnaryOperator && (ctUnaryOperator = (CtUnaryOperator)ctExpression).getKind() == UnaryOperatorKind.NOT) {
            return ctUnaryOperator.getOperand();
        }
        if (ctExpression instanceof CtBinaryOperator) {
            CtBinaryOperator ctBinaryOperator = (CtBinaryOperator)ctExpression;
            CtBinaryOperator result = ctBinaryOperator.clone();
            switch (ctBinaryOperator.getKind()) {
                case EQ: {
                    result.setKind(BinaryOperatorKind.NE);
                    return result;
                }
                case NE: 
                case BITXOR: {
                    result.setKind(BinaryOperatorKind.EQ);
                    return result;
                }
                case AND: {
                    result.setKind(BinaryOperatorKind.OR);
                    result.setLeftHandOperand(SpoonUtil.negate(result.getLeftHandOperand()));
                    result.setRightHandOperand(SpoonUtil.negate(result.getRightHandOperand()));
                    return result;
                }
                case OR: {
                    result.setKind(BinaryOperatorKind.AND);
                    result.setLeftHandOperand(SpoonUtil.negate(result.getLeftHandOperand()));
                    result.setRightHandOperand(SpoonUtil.negate(result.getRightHandOperand()));
                    return result;
                }
                case GE: {
                    result.setKind(BinaryOperatorKind.LT);
                    return result;
                }
                case GT: {
                    result.setKind(BinaryOperatorKind.LE);
                    return result;
                }
                case LE: {
                    result.setKind(BinaryOperatorKind.GT);
                    return result;
                }
                case LT: {
                    result.setKind(BinaryOperatorKind.GE);
                    return result;
                }
            }
        }
        return SpoonUtil.createUnaryOperator(UnaryOperatorKind.NOT, ctExpression.clone());
    }

    public static List<CtStatement> getEffectiveStatements(CtStatement ctStatement) {
        if (ctStatement instanceof CtStatementList) {
            CtStatementList ctStatementList = (CtStatementList)ctStatement;
            return SpoonUtil.getEffectiveStatements(ctStatementList.getStatements());
        }
        return SpoonUtil.getEffectiveStatements(List.of(ctStatement));
    }

    public static <T> CtExpression<T> resolveCtExpression(CtExpression<T> ctExpression) {
        if (ctExpression == null) {
            return null;
        }
        Evaluator evaluator = new Evaluator();
        return (CtExpression)evaluator.evaluate((CtElement)ctExpression);
    }

    public static CtStatement unwrapStatement(CtStatement statement) {
        CtBlock block;
        List<CtStatement> statements;
        if (statement instanceof CtBlock && (statements = SpoonUtil.getEffectiveStatements((CtStatement)(block = (CtBlock)statement))).size() == 1) {
            return statements.get(0);
        }
        return statement;
    }

    public static boolean isGetter(CtMethod<?> method) {
        return method.getSimpleName().startsWith("get") && method.getParameters().isEmpty() && !method.getType().getSimpleName().equals("void") && (method.isAbstract() || SpoonUtil.getEffectiveStatements((CtStatement)method.getBody()).size() == 1);
    }

    public static boolean isSetter(CtMethod<?> method) {
        return method.getSimpleName().startsWith("set") && method.getParameters().size() == 1 && method.getType().getSimpleName().equals("void") && (method.isAbstract() || SpoonUtil.getEffectiveStatements((CtStatement)method.getBody()).size() == 1);
    }

    public static boolean isInSetter(CtElement ctElement) {
        CtMethod parent = (CtMethod)ctElement.getParent(CtMethod.class);
        return parent != null && SpoonUtil.isSetter(parent);
    }

    public static boolean isPrimitiveNumeric(CtTypeReference<?> type) {
        return type.isPrimitive() && !type.getQualifiedName().equals("boolean") && !type.getQualifiedName().equals("char");
    }

    public static boolean isSignatureEqualTo(CtExecutableReference<?> ctExecutableReference, Class<?> returnType, String methodName, Class<?> ... parameterTypes) {
        TypeFactory factory = ctExecutableReference.getFactory().Type();
        return SpoonUtil.isSignatureEqualTo(ctExecutableReference, factory.createReference(returnType), methodName, (CtTypeReference[])Arrays.stream(parameterTypes).map(arg_0 -> ((TypeFactory)factory).createReference(arg_0)).toArray(CtTypeReference[]::new));
    }

    public static boolean isSignatureEqualTo(CtExecutableReference<?> ctExecutableReference, CtTypeReference<?> returnType, String methodName, CtTypeReference<?> ... parameterTypes) {
        if (!SpoonUtil.isTypeEqualTo(ctExecutableReference.getType(), returnType)) {
            return false;
        }
        if (!ctExecutableReference.getSimpleName().equals(methodName)) {
            return false;
        }
        List givenParameters = ctExecutableReference.getParameters();
        if (givenParameters.size() != parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (SpoonUtil.isTypeEqualTo((CtTypeReference)givenParameters.get(i), parameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static <T> CtInvocation<T> createStaticInvocation(CtTypeReference<?> targetType, String methodName, CtExpression<?> ... parameters) {
        Factory factory = targetType.getFactory();
        CtMethod methodHandle = null;
        List potentialMethods = targetType.getTypeDeclaration().getMethodsByName(methodName);
        methodHandle = potentialMethods.size() == 1 ? (CtMethod)potentialMethods.get(0) : targetType.getTypeDeclaration().getMethod(methodName, (CtTypeReference[])Arrays.stream(parameters).map(SpoonUtil::getExpressionType).toArray(CtTypeReference[]::new));
        return factory.createInvocation((CtExpression)factory.createTypeAccess(methodHandle.getDeclaringType().getReference()), methodHandle.getReference(), parameters);
    }

    public static <T> CtExpression<T> castExpression(Class<T> targetType, CtExpression<?> ctExpression) {
        return SpoonUtil.castExpression(ctExpression.getFactory().Type().createReference(targetType), ctExpression);
    }

    public static <T, R> CtLiteral<R> castLiteral(CtTypeReference<R> type, CtLiteral<T> literal) {
        CtLiteral result = literal.clone();
        result.setType(type.clone());
        if (SpoonUtil.isTypeEqualTo(type, String.class) && literal.getType().isPrimitive()) {
            result.setValue((Object)literal.getValue().toString());
            return result;
        }
        CtTypeReference targetType = type.unbox();
        if (targetType.isPrimitive()) {
            Number number;
            Object object;
            if (targetType.box().isSubtypeOf(type.getFactory().createCtTypeReference(Number.class))) {
                object = literal.getValue();
                if (object instanceof Number) {
                    number = (Number)object;
                    result.setValue((Object)FoldUtils.convert(type, number));
                } else {
                    Object object2 = literal.getValue();
                    if (object2 instanceof Character) {
                        Character character = (Character)object2;
                        result.setValue((Object)FoldUtils.convert(type, (int)character.charValue()));
                    }
                }
            }
            if (SpoonUtil.isTypeEqualTo(targetType, Character.TYPE)) {
                object = literal.getValue();
                if (object instanceof Number) {
                    number = (Number)object;
                    result.setValue((Object)Character.valueOf((char)number.intValue()));
                } else {
                    result.setValue((Object)Character.valueOf(((Character)literal.getValue()).charValue()));
                }
            } else if (SpoonUtil.isTypeEqualTo(targetType, Boolean.TYPE)) {
                result.setValue((Object)((Boolean)literal.getValue()));
            }
        } else {
            result.setValue(type.getActualClass().cast(literal.getValue()));
        }
        return result;
    }

    public static <T> CtTypeReference<?> getExpressionType(CtExpression<T> ctExpression) {
        CtTypeReference result = ctExpression.getType();
        List typeCasts = ctExpression.getTypeCasts();
        if (!typeCasts.isEmpty()) {
            result = (CtTypeReference)typeCasts.get(0);
        }
        return result;
    }

    public static <T, E extends CtExpression<T>> E castExpression(CtTypeReference<T> type, CtExpression<?> ctExpression) {
        if (SpoonUtil.getExpressionType(ctExpression).equals(type)) {
            return (E)ctExpression;
        }
        ArrayList<CtTypeReference> typeCasts = new ArrayList<CtTypeReference>(ctExpression.getTypeCasts());
        typeCasts.add(0, type.clone());
        ctExpression.setTypeCasts(typeCasts);
        return (E)RemoveRedundantCasts.removeRedundantCasts(ctExpression);
    }

    public static Optional<CtJavaDoc> getJavadoc(CtElement element) {
        if (element.getComments().isEmpty() || !(element.getComments().get(0) instanceof CtJavaDoc)) {
            return Optional.empty();
        }
        return Optional.of(((CtComment)element.getComments().get(0)).asJavaDoc());
    }

    public static boolean isStaticCallTo(CtInvocation<?> invocation, String typeName, String methodName) {
        CtTypeAccess access;
        CtExpression ctExpression;
        return invocation.getExecutable().isStatic() && (ctExpression = invocation.getTarget()) instanceof CtTypeAccess && (access = (CtTypeAccess)ctExpression).getAccessedType().getQualifiedName().equals(typeName) && invocation.getExecutable().getSimpleName().equals(methodName);
    }

    public static boolean isEffectivelyFinal(CtVariable<?> ctVariable) {
        if (ctVariable.getModifiers().contains(ModifierKind.FINAL)) {
            return true;
        }
        List<CtVariableAccess<?>> variableUses = SpoonUtil.findUsesOf(ctVariable);
        return variableUses.isEmpty() || variableUses.stream().noneMatch(variableAccess -> variableAccess instanceof CtVariableWrite);
    }

    public static <T> Optional<CtExpression<T>> getEffectivelyFinalExpression(CtVariable<T> ctVariable) {
        if (!SpoonUtil.isEffectivelyFinal(ctVariable)) {
            return Optional.empty();
        }
        return Optional.ofNullable(ctVariable.getDefaultExpression());
    }

    public static <T> boolean isImmutable(CtTypeReference<T> ctTypeReference) {
        ArrayDeque<CtTypeReference<T>> queue = new ArrayDeque<CtTypeReference<T>>(Collections.singletonList(ctTypeReference));
        HashSet<CtType> visited = new HashSet<CtType>();
        while (!queue.isEmpty()) {
            CtType ctType = ((CtTypeReference)queue.removeFirst()).getTypeDeclaration();
            if (ctType == null) {
                return false;
            }
            if (visited.contains(ctType) || ctType.getReference().unbox().isPrimitive() || SpoonUtil.isTypeEqualTo(ctType.getReference(), String.class)) continue;
            if (ctType.isShadow()) {
                return false;
            }
            for (CtFieldReference ctFieldReference : ctType.getAllFields()) {
                if (!SpoonUtil.isEffectivelyFinal(ctFieldReference.getFieldDeclaration())) {
                    return false;
                }
                queue.add(ctFieldReference.getType());
            }
            visited.add(ctType);
        }
        return true;
    }

    public static boolean isTypeEqualTo(CtTypeReference<?> ctType, Class<?> ... expected) {
        TypeFactory factory = ctType.getFactory().Type();
        return SpoonUtil.isTypeEqualTo(ctType, (CtTypeReference[])Arrays.stream(expected).map(arg_0 -> ((TypeFactory)factory).createReference(arg_0)).toArray(CtTypeReference[]::new));
    }

    public static boolean isTypeEqualTo(CtTypeReference<?> ctType, CtTypeReference<?> ... expected) {
        return Arrays.asList(expected).contains(ctType);
    }

    public static boolean isSubtypeOf(CtTypeReference<?> ctTypeReference, Class<?> expected) {
        return !(ctTypeReference instanceof CtTypeParameterReference) && ctTypeReference.isSubtypeOf(ctTypeReference.getFactory().Type().createReference(expected));
    }

    public static boolean isMainMethod(CtMethod<?> method) {
        return method.isStatic() && method.isPublic() && SpoonUtil.isSignatureEqualTo(method.getReference(), Void.TYPE, "main", String[].class);
    }

    private static Iterable<CtElement> parents(final CtElement ctElement) {
        return () -> new Iterator<CtElement>(){
            private CtElement current;
            {
                this.current = ctElement;
            }

            @Override
            public boolean hasNext() {
                return this.current.isParentInitialized();
            }

            @Override
            public CtElement next() throws NoSuchElementException {
                CtElement result;
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more parents");
                }
                this.current = result = this.current.getParent();
                return result;
            }
        };
    }

    private static <T, E> HashSet<T> newHashSet(Iterator<? extends E> elements, Function<E, ? extends T> mapper) {
        HashSet<T> set = new HashSet<T>();
        while (elements.hasNext()) {
            set.add(mapper.apply(elements.next()));
        }
        return set;
    }

    public static void visitCtCompilationUnit(CtModel ctModel, Consumer<? super CtCompilationUnit> lambda) {
        ctModel.getAllTypes().stream().map(CtElement::getPosition).filter(SourcePosition::isValidPosition).map(SourcePosition::getCompilationUnit).distinct().forEach(lambda);
    }

    public static CtElement findCommonParent(CtElement firstElement, Iterable<? extends CtElement> others) {
        LinkedHashSet<IdentityKey<CtElement>> ctParents = new LinkedHashSet<IdentityKey<CtElement>>();
        ctParents.add(IdentityKey.of(firstElement));
        SpoonUtil.parents(firstElement).forEach(element -> ctParents.add(IdentityKey.of(element)));
        for (CtElement ctElement : others) {
            ctParents.retainAll(SpoonUtil.newHashSet(SpoonUtil.parents(ctElement).iterator(), IdentityKey::of));
        }
        return (CtElement)((IdentityKey)ctParents.iterator().next()).value();
    }

    public static boolean isInnerClass(CtTypeMember type) {
        return type.getDeclaringType() != null;
    }

    public static boolean isOverriddenMethod(CtMethod<?> ctMethod) {
        Collection topDefinitions = ctMethod.getTopDefinitions();
        return !topDefinitions.isEmpty();
    }

    public static boolean isInOverriddenMethod(CtElement ctElement) {
        CtMethod ctMethod = (CtMethod)ctElement.getParent(CtMethod.class);
        if (ctMethod == null) {
            return false;
        }
        return SpoonUtil.isOverriddenMethod(ctMethod);
    }

    public static boolean isInvocation(CtStatement statement) {
        return statement instanceof CtInvocation || statement instanceof CtConstructorCall || statement instanceof CtLambda;
    }

    public static boolean isInMainMethod(CtElement ctElement) {
        CtMethod ctMethod = (CtMethod)ctElement.getParent(CtMethod.class);
        if (ctMethod == null) {
            return false;
        }
        return SpoonUtil.isMainMethod(ctMethod);
    }

    public static List<CtElement> findUsesIn(CtElement ctElement, CtElement in) {
        return new ArrayList<CtElement>(in.getElements((Filter)new UsesFilter(ctElement)));
    }

    public static CtElement getReferenceDeclaration(CtReference ctReference) {
        CtLocalVariable target = ctReference.getDeclaration();
        if (target == null && ctReference instanceof CtTypeReference) {
            CtTypeReference ctTypeReference = (CtTypeReference)ctReference;
            target = ctTypeReference.getTypeDeclaration();
        }
        if (target == null && ctReference instanceof CtExecutableReference) {
            CtExecutableReference ctExecutableReference = (CtExecutableReference)ctReference;
            target = ctExecutableReference.getExecutableDeclaration();
        }
        if (target == null && ctReference instanceof CtFieldReference) {
            CtFieldReference ctFieldReference = (CtFieldReference)ctReference;
            target = ctFieldReference.getFieldDeclaration();
        }
        if (target == null && ctReference instanceof CtLocalVariableReference) {
            CtLocalVariableReference ctLocalVariableReference = (CtLocalVariableReference)ctReference;
            target = SpoonUtil.getLocalVariableDeclaration(ctLocalVariableReference);
        }
        return target;
    }

    private static <T> CtLocalVariable<T> getLocalVariableDeclaration(CtLocalVariableReference<T> ctLocalVariableReference) {
        if (ctLocalVariableReference.getDeclaration() != null) {
            return ctLocalVariableReference.getDeclaration();
        }
        for (CtElement parent : SpoonUtil.parents(ctLocalVariableReference)) {
            CtLocalVariable candidate = (CtLocalVariable)parent.filterChildren((Filter)new TypeFilter(CtTypePattern.class)).filterChildren((Filter)new CompositeFilter(FilteringOperator.INTERSECTION, new Filter[]{new TypeFilter(CtLocalVariable.class), element -> element.getReference().equals(ctLocalVariableReference)})).first();
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    public static <T> List<CtVariableAccess<T>> findUsesOf(CtVariable<T> ctVariable) {
        return SpoonUtil.findUses(ctVariable).stream().map(ctElement -> (CtVariableAccess)ctElement).collect(Collectors.toList());
    }

    public static List<CtElement> findUsesOf(CtTypeMember ctTypeMember) {
        return SpoonUtil.findUses((CtElement)ctTypeMember);
    }

    public static <T> List<CtElement> findUsesOf(CtExecutable<T> ctExecutable) {
        return SpoonUtil.findUses(ctExecutable);
    }

    public static boolean hasAnyUses(CtElement ctElement, Predicate<? super CtElement> predicate) {
        Filter[] filterArray = new Filter[2];
        filterArray[0] = predicate::test;
        filterArray[1] = new UsesFilter(ctElement);
        return ctElement.getFactory().getModel().filterChildren((Filter)new CompositeFilter(FilteringOperator.INTERSECTION, filterArray)).first(CtElement.class) != null;
    }

    public static boolean hasAnyUsesIn(CtElement ctElement, CtElement toSearchIn, Predicate<? super CtElement> predicate) {
        Filter[] filterArray = new Filter[2];
        filterArray[0] = predicate::test;
        filterArray[1] = new UsesFilter(ctElement);
        return toSearchIn.filterChildren((Filter)new CompositeFilter(FilteringOperator.INTERSECTION, filterArray)).first(CtElement.class) != null;
    }

    public static List<CtElement> findUses(CtElement ctElement) {
        return new ArrayList<CtElement>(ctElement.getFactory().getModel().getElements((Filter)new UsesFilter(ctElement)));
    }

    public static Optional<CtStatement> getPreviousStatement(CtStatement ctStatement) {
        CtStatementList ctStatementList;
        List statements;
        int index;
        CtElement ctElement = ctStatement.getParent();
        if (ctElement instanceof CtStatementList && (index = (statements = (ctStatementList = (CtStatementList)ctElement).getStatements()).indexOf(ctStatement)) > 0) {
            return Optional.of((CtStatement)statements.get(index - 1));
        }
        return Optional.empty();
    }

    public static List<CtStatement> getNextStatements(CtStatement ctStatement) {
        CtStatementList ctStatementList;
        List statements;
        int index;
        ArrayList<CtStatement> result = new ArrayList<CtStatement>();
        CtElement ctElement = ctStatement.getParent();
        if (ctElement instanceof CtStatementList && (index = (statements = (ctStatementList = (CtStatementList)ctElement).getStatements()).indexOf(ctStatement)) > 0) {
            result.addAll(statements.subList(index + 1, statements.size()));
        }
        return result;
    }

    public static Optional<Effect> tryMakeEffect(CtStatement ctStatement) {
        return TerminalStatement.of(ctStatement).or(() -> AssignmentStatement.of(ctStatement));
    }

    public static Optional<Effect> getSingleEffect(Collection<? extends CtStatement> ctStatements) {
        List<CtStatement> statements = SpoonUtil.getEffectiveStatements(ctStatements);
        if (!(statements.size() == 1 || statements.size() == 2 && statements.get(1) instanceof CtBreak)) {
            return Optional.empty();
        }
        return SpoonUtil.tryMakeEffect(statements.get(0));
    }

    public static List<Effect> getCasesEffects(Iterable<? extends CtCase<?>> ctCases) {
        ArrayList<Effect> effects = new ArrayList<Effect>();
        for (CtCase<?> ctCase : ctCases) {
            Optional<Effect> effect = SpoonUtil.getSingleEffect(ctCase.getStatements());
            if (effect.isEmpty()) {
                return new ArrayList<Effect>();
            }
            Effect resolvedEffect = effect.get();
            if (ctCase.getCaseExpressions().isEmpty() && resolvedEffect instanceof TerminalEffect) continue;
            effects.add(resolvedEffect);
        }
        if (effects.isEmpty()) {
            return new ArrayList<Effect>();
        }
        return effects;
    }

    public static SourcePosition findPosition(CtElement ctElement) {
        if (ctElement.getPosition().isValidPosition()) {
            return ctElement.getPosition();
        }
        for (CtElement element : SpoonUtil.parents(ctElement)) {
            if (!element.getPosition().isValidPosition()) continue;
            return element.getPosition();
        }
        return null;
    }

    public static String formatSourcePosition(SourcePosition sourcePosition) {
        return String.format("%s:L%d", FileNameUtils.getBaseName((String)sourcePosition.getFile().getName()), sourcePosition.getLine());
    }

    public static SourcePosition getNamePosition(CtNamedElement ctNamedElement) {
        SourcePosition position = ctNamedElement.getPosition();
        if (position instanceof CompoundSourcePosition) {
            CompoundSourcePosition compoundSourcePosition = (CompoundSourcePosition)position;
            return ctNamedElement.getFactory().createSourcePosition(position.getCompilationUnit(), compoundSourcePosition.getNameStart(), compoundSourcePosition.getNameEnd(), position.getCompilationUnit().getLineSeparatorPositions());
        }
        return position;
    }

    private record IdentityKey<T>(T value) {
        public static <T> IdentityKey<T> of(T value) {
            return new IdentityKey<T>(value);
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.value);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            IdentityKey that = (IdentityKey)obj;
            return this.value == that.value();
        }
    }

    public static class UsesFilter
    implements Filter<CtElement> {
        private final Filter<CtElement> filter;

        public UsesFilter(CtElement ctElement) {
            Filter filter;
            if (ctElement instanceof CtVariable) {
                CtParameter ctParameter;
                CtExecutable ctExecutable;
                CtVariable ctVariable = (CtVariable)ctElement;
                filter = new FilterAdapter<CtVariableAccess, CtElement>(new BetterVariableAccessFilter(ctVariable), CtVariableAccess.class);
                if (ctVariable instanceof CtParameter && (ctExecutable = (ctParameter = (CtParameter)ctVariable).getParent()) instanceof CtMethod) {
                    CtMethod ctMethod = (CtMethod)ctExecutable;
                    filter = ctMethod.getFactory().getModel().getElements((Filter)new OverridingMethodFilter(ctMethod)).stream().flatMap(method -> method.getParameters().stream().filter(ctParameter::equals).findAny().stream()).map(parameter -> new FilterAdapter(new BetterVariableAccessFilter((CtVariable<?>)parameter), CtVariableAccess.class)).reduce(filter, (currentFilter, parameterFilter) -> new CompositeFilter(FilteringOperator.UNION, new Filter[]{currentFilter, parameterFilter}));
                }
            } else if (ctElement instanceof CtExecutable) {
                CtExecutable ctExecutable = (CtExecutable)ctElement;
                filter = UsesFilter.buildExecutableFilter(ctExecutable);
            } else if (ctElement instanceof CtTypeParameter) {
                CtTypeParameter ctTypeParameter = (CtTypeParameter)ctElement;
                filter = new FilterAdapter<CtReference, CtElement>((Filter<CtReference>)new DirectReferenceFilter((CtReference)ctTypeParameter.getReference()), CtReference.class);
            } else if (ctElement instanceof CtType) {
                CtType ctType = (CtType)ctElement;
                filter = new FilterAdapter<CtElement, CtElement>(new TypeUsesFilter(ctType), CtElement.class);
            } else if (ctElement instanceof CtTypeMember) {
                CtTypeMember ctTypeMember = (CtTypeMember)ctElement;
                filter = new FilterAdapter<CtReference, CtElement>((Filter<CtReference>)new DirectReferenceFilter(ctTypeMember.getReference()), CtReference.class);
            } else {
                throw new IllegalArgumentException("Unsupported element: " + ctElement.getClass().getName());
            }
            this.filter = new CompositeFilter(FilteringOperator.INTERSECTION, new Filter[]{EXPLICIT_ELEMENT_FILTER, filter});
        }

        public boolean matches(CtElement element) {
            return this.filter.matches(element);
        }

        private static Filter<CtElement> buildExecutableFilter(CtExecutable<?> ctExecutable) {
            CompositeFilter filter = new FilterAdapter(new BetterInvocationFilter(ctExecutable), CtAbstractInvocation.class);
            filter = new CompositeFilter(FilteringOperator.UNION, new Filter[]{filter, new FilterAdapter(new ExecutableReferenceExpressionFilter(ctExecutable), CtExecutableReferenceExpression.class)});
            if (ctExecutable instanceof CtMethod) {
                CtMethod ctMethod = (CtMethod)ctExecutable;
                filter = new CompositeFilter(FilteringOperator.UNION, new Filter[]{filter, new FilterAdapter((Filter<CtMethod>)new OverridingMethodFilter(ctMethod), CtMethod.class)});
            }
            return filter;
        }
    }

    private record TypeUsesFilter(CtType<?> ctType) implements Filter<CtElement>
    {
        private boolean isType(CtTypeReference<?> ctTypeReference) {
            return this.ctType.getReference() == ctTypeReference || this.ctType == ctTypeReference.getTypeDeclaration();
        }

        public boolean matches(CtElement ctElement) {
            if (ctElement instanceof CtArrayTypeReference) {
                CtArrayTypeReference ctArrayTypeReference = (CtArrayTypeReference)ctElement;
                return this.isType(ctArrayTypeReference.getArrayType());
            }
            if (ctElement instanceof CtTypeReference) {
                CtTypeReference ctTypeReference = (CtTypeReference)ctElement;
                return this.isType(ctTypeReference);
            }
            return false;
        }
    }

    private record ExecutableReferenceExpressionFilter(CtExecutable<?> executable) implements Filter<CtExecutableReferenceExpression<?, ?>>
    {
        public boolean matches(CtExecutableReferenceExpression<?, ?> expression) {
            CtExecutableReference invocationExecutable = expression.getExecutable();
            return invocationExecutable.equals(this.executable.getReference()) || this.executable.equals((Object)invocationExecutable.getExecutableDeclaration()) || invocationExecutable.isOverriding(this.executable.getReference());
        }
    }

    private record BetterInvocationFilter(CtExecutable<?> executable) implements Filter<CtAbstractInvocation<?>>
    {
        public boolean matches(CtAbstractInvocation<?> invocation) {
            CtExecutableReference invocationExecutable = invocation.getExecutable();
            return invocationExecutable.equals(this.executable.getReference()) || this.executable.equals((Object)invocationExecutable.getExecutableDeclaration()) || invocationExecutable.isOverriding(this.executable.getReference());
        }
    }

    private record BetterVariableAccessFilter<T extends CtVariableAccess<?>>(CtVariable<?> ctVariable) implements Filter<T>
    {
        public boolean matches(T element) {
            return SpoonUtil.getReferenceDeclaration((CtReference)element.getVariable()) != null && SpoonUtil.getReferenceDeclaration((CtReference)element.getVariable()) == this.ctVariable;
        }
    }

    public record FilterAdapter<T extends CtElement, U extends CtElement>(Filter<T> filter, Class<T> type) implements Filter<U>
    {
        public boolean matches(U element) {
            if (this.type.isInstance(element)) {
                return this.filter.matches((CtElement)this.type.cast(element));
            }
            return false;
        }
    }
}

