/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated;

import de.firemage.autograder.core.CodePosition;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.Problem;
import de.firemage.autograder.core.ProblemImpl;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.check.Check;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.file.SourceInfo;
import de.firemage.autograder.core.integrated.IntegratedInCodeProblem;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.ArrayList;
import java.util.List;
import spoon.reflect.declaration.CtElement;

public abstract class IntegratedCheck
implements Check {
    private final List<Problem> problems = new ArrayList<Problem>();
    private SourceInfo sourceInfo;

    protected IntegratedCheck() {
    }

    protected void addLocalProblem(CtElement element, Translatable explanation, ProblemType problemType) {
        this.problems.add(new IntegratedInCodeProblem(this, element, explanation, problemType, this.sourceInfo));
    }

    protected void addLocalProblem(CodePosition position, Translatable explanation, ProblemType problemType) {
        this.problems.add(new ProblemImpl(this, position, explanation, problemType){});
    }

    public List<Problem> run(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis, SourceInfo sourceInfo) {
        this.problems.clear();
        this.sourceInfo = sourceInfo;
        this.check(staticAnalysis, dynamicAnalysis);
        return this.problems;
    }

    protected abstract void check(StaticAnalysis var1, DynamicAnalysis var2);

    @Override
    public LocalizedMessage getLinter() {
        return new LocalizedMessage("linter-integrated");
    }

    protected SourceInfo getRoot() {
        return this.sourceInfo;
    }
}

