/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated;

import de.firemage.autograder.core.LinterStatus;
import de.firemage.autograder.core.check.Check;
import de.firemage.autograder.core.dynamic.DockerConsoleRunner;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.dynamic.RunnerException;
import de.firemage.autograder.core.dynamic.TestRunResult;
import de.firemage.autograder.core.file.UploadedFile;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import de.firemage.autograder.core.integrated.graph.GraphAnalysis;
import de.firemage.autograder.core.parallel.AnalysisScheduler;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.reflect.CtModel;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtModule;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class IntegratedAnalysis {
    private static final boolean ENSURE_NO_ORPHANS = false;
    private static final boolean ENSURE_NO_MODEL_CHANGES = false;
    private static final Logger logger = LoggerFactory.getLogger(IntegratedAnalysis.class);
    private final UploadedFile file;
    private final Path tmpPath;
    private final Map<String, FileSystem> openFileSystems = new HashMap<String, FileSystem>();
    private final CtModel originalModel;
    private final StaticAnalysis staticAnalysis;
    private final GraphAnalysis graphAnalysis;
    private DynamicAnalysis dynamicAnalysis;
    private Set<CtElement> cachedOriginalElements = null;

    public IntegratedAnalysis(UploadedFile file, Path tmpPath) {
        this.file = file;
        this.tmpPath = tmpPath;
        StaticAnalysis temporaryAnalysis = new StaticAnalysis(file.getModel(), file.getCompilationResult());
        this.originalModel = temporaryAnalysis.getModel();
        this.staticAnalysis = new StaticAnalysis(file.getModel(), file.getCompilationResult());
        this.graphAnalysis = null;
        this.dynamicAnalysis = new DynamicAnalysis(List.of());
    }

    public void runDynamicAnalysis(Path tests, Consumer<LinterStatus> statusConsumer) throws RunnerException, InterruptedException {
        try {
            DockerConsoleRunner runner = new DockerConsoleRunner(this.toPath(this.getClass().getResource("/executor.jar")), this.toPath(this.getClass().getResource("/agent.jar")), tests, this.tmpPath);
            List<TestRunResult> results = runner.runTests(this.staticAnalysis, this.file.getCompilationResult().jar(), statusConsumer);
            this.dynamicAnalysis = new DynamicAnalysis(results);
        }
        catch (IOException | URISyntaxException e) {
            throw new RunnerException(e);
        }
        finally {
            this.closeOpenFileSystems();
        }
    }

    private Path toPath(URL resource) throws URISyntaxException, IOException {
        if (resource == null) {
            throw new IllegalArgumentException("URL is null");
        }
        URI uri = resource.toURI();
        if (!uri.toString().contains("!")) {
            return Path.of(uri);
        }
        String[] path = uri.toString().split("!", 2);
        FileSystem fs = this.createFileSystem(path[0]);
        return fs.getPath(path[1], new String[0]);
    }

    private FileSystem createFileSystem(String path) throws IOException {
        FileSystem existingFileSystem = this.openFileSystems.get(path);
        if (existingFileSystem != null) {
            return existingFileSystem;
        }
        FileSystem newFileSystem = FileSystems.newFileSystem(URI.create(path), new HashMap());
        this.openFileSystems.put(path, newFileSystem);
        return newFileSystem;
    }

    private void closeOpenFileSystems() {
        for (FileSystem openFileSystem : this.openFileSystems.values()) {
            try {
                openFileSystem.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        this.openFileSystems.clear();
    }

    public void lint(List<IntegratedCheck> checks, Consumer<LinterStatus> statusConsumer, AnalysisScheduler scheduler) {
        statusConsumer.accept(LinterStatus.BUILDING_CODE_MODEL);
        this.staticAnalysis.getCodeModel().ensureModelBuild();
        statusConsumer.accept(LinterStatus.RUNNING_INTEGRATED_CHECKS);
        scheduler.submitTask((s, reporter) -> {
            for (IntegratedCheck check : checks) {
                long beforeTime = System.nanoTime();
                reporter.reportProblems(check.run(this.staticAnalysis, this.dynamicAnalysis, this.file.getSource()));
                long afterTime = System.nanoTime();
                logger.info("Completed check " + check.getClass().getSimpleName() + " in " + (afterTime - beforeTime) / 1000000L + "ms");
                this.assertModelIntegrity(check);
            }
        });
    }

    private void assertModelIntegrity(Check currentCheck) {
        List<CtElement> orphans;
        CtModel linterModel = this.staticAnalysis.getModel();
        String checkName = currentCheck.getClass().getSimpleName();
        if (SpoonUtil.isInJunitTest() && !this.isModelEqualTo(this.originalModel, linterModel)) {
            throw new IllegalStateException("The model was changed by the check: %s".formatted(checkName));
        }
        if (SpoonUtil.isInJunitTest() && !(orphans = IntegratedAnalysis.findOrphans(linterModel)).isEmpty()) {
            throw new IllegalStateException("The check %s introduced new elements into the model without parents (did you forget to clone before passing the element to a setter?): %s".formatted(checkName, orphans.stream().map(element -> "%s(\"%s\")".formatted(element.getClass().getSimpleName(), element)).toList()));
        }
    }

    private boolean isModelEqualTo(CtModel original, CtModel toCheck) {
        if (this.cachedOriginalElements == null) {
            this.cachedOriginalElements = new HashSet<CtElement>(original.getElements((Filter)new TypeFilter(CtElement.class)));
        }
        Set<CtElement> originalElements = this.cachedOriginalElements;
        List changedElements = toCheck.getElements(element -> !originalElements.contains(element));
        return changedElements.isEmpty();
    }

    private static boolean isOrphan(CtElement ctElement) {
        CtElement parent;
        CtPackageReference ctPackage;
        if (ctElement instanceof CtPackageReference && (ctPackage = (CtPackageReference)ctElement).getQualifiedName().startsWith("java.")) {
            return false;
        }
        if (ctElement instanceof CtTypeReference || ctElement instanceof CtLiteral || ctElement instanceof CtPackageReference) {
            return false;
        }
        CtModule root = ctElement.getFactory().getModel().getUnnamedModule();
        if (root == ctElement) {
            return false;
        }
        for (parent = ctElement.getParent(); parent.isParentInitialized() && parent != root; parent = parent.getParent()) {
        }
        return parent != root;
    }

    private static List<CtElement> findOrphans(CtModel ctModel) {
        return ctModel.getElements(IntegratedAnalysis::isOrphan);
    }

    public StaticAnalysis getStaticAnalysis() {
        return this.staticAnalysis;
    }

    public DynamicAnalysis getDynamicAnalysis() {
        return this.dynamicAnalysis;
    }
}

