/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated;

import com.google.common.base.CaseFormat;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.stream.Stream;

public final class IdentifierNameUtils {
    private IdentifierNameUtils() {
    }

    public static boolean isUpperSnakeCase(String identifier) {
        for (char c : identifier.toCharArray()) {
            if (Character.isUpperCase(c) || c == '_' || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCamelCase(String identifier) {
        if (!Character.isLowerCase(identifier.charAt(0))) {
            return false;
        }
        return IdentifierNameUtils.isCamelCase(identifier);
    }

    public static boolean isUpperCamelCase(String identifier) {
        if (!Character.isUpperCase(identifier.charAt(0))) {
            return false;
        }
        return IdentifierNameUtils.isCamelCase(identifier);
    }

    public static boolean isCamelCase(String identifier) {
        for (char c : identifier.toCharArray()) {
            if (Character.isAlphabetic(c) || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static String toUpperSnakeCase(String identifier) {
        if (IdentifierNameUtils.isUpperSnakeCase(identifier)) {
            return identifier;
        }
        return (String)IdentifierNameUtils.getCaseFormat(identifier).converterTo(CaseFormat.UPPER_UNDERSCORE).convert((Object)identifier);
    }

    public static String toLowerCamelCase(String identifier) {
        if (IdentifierNameUtils.isLowerCamelCase(identifier)) {
            return identifier;
        }
        return (String)IdentifierNameUtils.getCaseFormat(identifier).converterTo(CaseFormat.LOWER_CAMEL).convert((Object)identifier);
    }

    public static Stream<String> split(String identifier) {
        return Arrays.stream(IdentifierNameUtils.toUpperSnakeCase(identifier).split("_")).map(String::toLowerCase);
    }

    private static CaseFormat getCaseFormat(String identifier) {
        if (IdentifierNameUtils.isLowerCamelCase(identifier = Normalizer.normalize(identifier, Normalizer.Form.NFC))) {
            return CaseFormat.LOWER_CAMEL;
        }
        if (IdentifierNameUtils.isUpperCamelCase(identifier)) {
            return CaseFormat.UPPER_CAMEL;
        }
        if (IdentifierNameUtils.isUpperSnakeCase(identifier)) {
            return CaseFormat.UPPER_UNDERSCORE;
        }
        if (IdentifierNameUtils.isUpperSnakeCase(identifier.toUpperCase())) {
            return CaseFormat.LOWER_UNDERSCORE;
        }
        throw new IllegalArgumentException("Identifier '%s' is not in a (supported) naming convention".formatted(identifier));
    }
}

