/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.file;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;

public final class SourcePath
implements Comparable<SourcePath>,
Serializable {
    private static final String SEPARATOR = "/";
    private final List<String> segments;

    private SourcePath(List<String> segments) {
        this.segments = segments;
    }

    public static SourcePath of(Path path) {
        return new SourcePath(new ArrayList<String>(StreamSupport.stream(path.spliterator(), false).map(segment -> segment.getFileName().toString()).toList()));
    }

    public static SourcePath of(List<String> path) {
        return new SourcePath(path);
    }

    public static SourcePath of(String first, String ... more) {
        ArrayList<String> result = new ArrayList<String>(List.of(first));
        result.addAll(Arrays.asList(more));
        return SourcePath.of(result);
    }

    public String getName() {
        return this.segments.get(this.segments.size() - 1);
    }

    Optional<SourcePath> makeRelativeTo(SourcePath root) {
        if (root.segments.size() >= this.segments.size()) {
            return Optional.empty();
        }
        for (int i = 0; i < root.segments.size(); ++i) {
            if (this.segments.get(i).equals(root.segments.get(i))) continue;
            return Optional.empty();
        }
        ArrayList<String> result = new ArrayList<String>(this.segments.subList(root.segments.size(), this.segments.size()));
        return Optional.of(SourcePath.of(result));
    }

    SourcePath resolve(SourcePath other) {
        ArrayList<String> result = new ArrayList<String>(this.segments);
        result.addAll(other.segments);
        return SourcePath.of(result);
    }

    public Path toPath() {
        return Path.of(this.toString(), new String[0]);
    }

    public boolean equals(Object other) {
        if (!(other instanceof SourcePath)) {
            return false;
        }
        SourcePath otherPath = (SourcePath)other;
        return this.segments.equals(otherPath.segments);
    }

    public int hashCode() {
        return this.segments.hashCode();
    }

    public String toString() {
        return String.join((CharSequence)SEPARATOR, this.segments);
    }

    @Override
    public int compareTo(SourcePath other) {
        if (this.equals(other)) {
            return 0;
        }
        return this.toString().compareTo(other.toString());
    }
}

