/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.errorprone;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.FileUtils;

public record TempLocation(File tempLocation) implements Serializable,
Closeable
{
    private static final Random RANDOM = new Random();
    private static final String TEMPORARY_DIR_FORMAT = "%s%d";

    public static TempLocation fromPath(Path path) {
        return new TempLocation(path.toFile());
    }

    public static TempLocation of(String first, String ... other) {
        return TempLocation.fromPath(Path.of(first, other));
    }

    public static TempLocation random() {
        try {
            return TempLocation.fromPath(Files.createTempDirectory("random", new FileAttribute[0]));
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not create temporary directory", e);
        }
    }

    private List<IOFunction<String, Path>> temporaryDirectories() {
        return List.of(prefix -> TempLocation.makeDirectory(this.tempLocation.toPath(), prefix), prefix -> TempLocation.makeDirectory(Path.of(System.getProperty("java.io.tmpdir"), new String[0]), prefix), x$0 -> Files.createTempDirectory(x$0, new FileAttribute[0]), prefix -> TempLocation.makeDirectory(Path.of(".", ".autograder-tmp").toAbsolutePath(), prefix));
    }

    private static Path makeDirectory(Path path, String prefix) throws IOException {
        Path directory;
        Path absolutePath = path.toAbsolutePath();
        if (!Files.exists(absolutePath, new LinkOption[0])) {
            Files.createDirectories(absolutePath, new FileAttribute[0]);
        }
        if (!Files.isDirectory(absolutePath, new LinkOption[0])) {
            throw new IllegalArgumentException("the path '%s' is not a directory".formatted(absolutePath));
        }
        while (Files.exists(directory = absolutePath.resolve(TEMPORARY_DIR_FORMAT.formatted(prefix, RANDOM.nextLong())), new LinkOption[0])) {
        }
        return Files.createDirectory(directory, new FileAttribute[0]);
    }

    public TempLocation createTempDirectory(String prefix) throws IOException {
        if (prefix.contains(File.pathSeparator)) {
            throw new IllegalArgumentException("the prefix '%s' contains a path separator".formatted(prefix));
        }
        for (IOFunction<String, Path> tempDir : this.temporaryDirectories()) {
            try {
                return TempLocation.fromPath(tempDir.apply(prefix));
            }
            catch (IOException iOException) {
            }
        }
        throw new IllegalStateException("could not find a temporary directory");
    }

    public Path createTempFile(String name) throws IOException {
        Path path = this.toPath().resolve(name);
        while (path.toFile().exists()) {
            path = this.toPath().resolve(RANDOM.nextLong() + name);
        }
        return Files.createFile(path, new FileAttribute[0]);
    }

    public Path toPath() {
        return this.tempLocation.toPath();
    }

    @Override
    public void close() throws IOException {
        FileUtils.forceDeleteOnExit((File)this.toPath().toFile());
    }

    @FunctionalInterface
    private static interface IOFunction<I, R> {
        public R apply(I var1) throws IOException;
    }
}

