/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.cpd;

import de.firemage.autograder.core.Problem;
import de.firemage.autograder.core.check.general.CopyPasteCheck;
import de.firemage.autograder.core.cpd.CPDInCodeProblem;
import de.firemage.autograder.core.file.CompilationUnit;
import de.firemage.autograder.core.file.UploadedFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.tools.JavaFileObject;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.JavaLanguage;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.SourceCode;

public class CPDLinter {
    public List<Problem> lint(UploadedFile file, List<CopyPasteCheck> checks) throws IOException {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        for (CopyPasteCheck check : checks) {
            CPDConfiguration cpdConfig = new CPDConfiguration();
            cpdConfig.setFailOnViolation(false);
            cpdConfig.setLanguage((Language)new JavaLanguage());
            cpdConfig.setMinimumTileSize(check.getTokenCount());
            CPD cpd = new CPD(cpdConfig);
            for (CompilationUnit compilationUnit : file.getSource().compilationUnits()) {
                JavaFileObject javaFileObject = compilationUnit.toJavaFileObject();
                cpd.add(new SourceCode((SourceCode.CodeLoader)new SourceCode.ReaderCodeLoader(javaFileObject.openReader(true), compilationUnit.path().toString())));
            }
            cpd.go();
            cpd.getMatches().forEachRemaining(match -> problems.add(new CPDInCodeProblem(check, (Match)match, file.getSource())));
        }
        return problems;
    }
}

