/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.compiler;

import de.firemage.autograder.core.compiler.CompilationDiagnostic;
import de.firemage.autograder.core.compiler.CompilationFailureException;
import de.firemage.autograder.core.compiler.CompilationResult;
import de.firemage.autograder.core.compiler.JavaVersion;
import de.firemage.autograder.core.compiler.SeparateBinaryFileManager;
import de.firemage.autograder.core.errorprone.TempLocation;
import de.firemage.autograder.core.file.CompilationUnit;
import de.firemage.autograder.core.file.SourceInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;

public record Compiler(TempLocation tempLocation, JavaVersion javaVersion) {
    static final Locale COMPILER_LOCALE = Locale.US;

    public Optional<CompilationResult> compileToJar(SourceInfo input) throws IOException, CompilationFailureException {
        return this.compileAndIgnoreSuppressWarnings(input);
    }

    private Optional<CompilationResult> compileAndIgnoreSuppressWarnings(SourceInfo input) throws IOException, CompilationFailureException {
        Optional<CompilationResult> compilationResult;
        try (TempLocation modifiedOutput = this.tempLocation.createTempDirectory(input.getName() + "_modified");){
            SourceInfo copiedVersion = input.copyTo(modifiedOutput.toPath());
            List<CompilationUnit> compilationUnits = copiedVersion.compilationUnits();
            for (CompilationUnit file : compilationUnits) {
                JavaFileObject javaFileObject = file.toJavaFileObject();
                String content = file.readString();
                Pattern pattern = Pattern.compile("@SuppressWarnings\\((.+?)\\)", 32);
                String patched = pattern.matcher(content).replaceAll(matchResult -> {
                    String group = matchResult.group(1);
                    Object result = "";
                    int i = 0;
                    int length = group.length();
                    for (char c : group.toCharArray()) {
                        result = i == 0 ? (String)result + "{" : (i == length - 1 ? (String)result + "}" : (c == '\r' || c == '\n' ? (String)result + c : (String)result + " "));
                        ++i;
                    }
                    return "@SuppressWarnings(%s)".formatted(result);
                });
                Writer writer = javaFileObject.openWriter();
                try {
                    writer.write(patched);
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            compilationResult = this.compile(copiedVersion);
        }
        List diagnostics = compilationResult.map(CompilationResult::diagnostics).orElse(List.of());
        return this.compile(input).map(res -> new CompilationResult(res.jar(), diagnostics));
    }

    private Optional<CompilationResult> compile(SourceInfo input) throws IOException, CompilationFailureException {
        Path jar;
        List<CompilationUnit> compilationUnits = input.compilationUnits();
        if (compilationUnits.isEmpty()) {
            return Optional.empty();
        }
        Charset charset = compilationUnits.get(0).charset();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        StringWriter output = new StringWriter();
        ArrayList<CompilationDiagnostic> diagnostics = new ArrayList<CompilationDiagnostic>();
        try (TempLocation compilerOutput = this.tempLocation.createTempDirectory(input.getName() + "_compiled");){
            SeparateBinaryFileManager fileManager = new SeparateBinaryFileManager(compiler.getStandardFileManager(diagnosticCollector, Locale.US, charset), compilerOutput.toPath().toFile(), charset);
            boolean isSuccessful = compiler.getTask(output, fileManager, diagnosticCollector, Arrays.asList("-Xlint:all", "-Xlint:-processing", "-Xlint:-serial", "--release=" + this.javaVersion.getVersionString()), null, compilationUnits.stream().map(CompilationUnit::toJavaFileObject).toList()).call();
            output.flush();
            output.close();
            diagnostics.addAll(diagnosticCollector.getDiagnostics().stream().filter(diagnostic -> diagnostic.getSource() != null).map(diagnostic -> new CompilationDiagnostic((Diagnostic<? extends JavaFileObject>)diagnostic, input)).toList());
            if (!isSuccessful) {
                throw new CompilationFailureException(diagnostics);
            }
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            jar = this.tempLocation.createTempFile(input.getName() + ".jar");
            try (JarOutputStream jarOut = new JarOutputStream((OutputStream)new FileOutputStream(jar.toFile()), manifest);){
                Compiler.addToJar(compilerOutput.toPath().normalize(), compilerOutput.toPath().toFile(), jarOut);
            }
        }
        return Optional.of(new CompilationResult(jar, diagnostics));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToJar(Path root, File source, JarOutputStream target) throws IOException {
        Object relativePath = root.relativize(source.toPath().normalize()).toString().replace("\\", "/");
        try (BufferedInputStream in = null;){
            if (source.isDirectory()) {
                if (!((String)relativePath).isEmpty()) {
                    if (!((String)relativePath).endsWith("/")) {
                        relativePath = (String)relativePath + "/";
                    }
                    JarEntry entry = new JarEntry((String)relativePath);
                    entry.setTime(source.lastModified());
                    target.putNextEntry(entry);
                    target.closeEntry();
                }
                for (File nestedFile : source.listFiles()) {
                    Compiler.addToJar(root, nestedFile, target);
                }
            } else {
                int count;
                JarEntry entry = new JarEntry((String)relativePath);
                entry.setTime(source.lastModified());
                target.putNextEntry(entry);
                in = new BufferedInputStream(new FileInputStream(source));
                byte[] buffer = new byte[1024];
                while ((count = in.read(buffer)) != -1) {
                    target.write(buffer, 0, count);
                }
                target.closeEntry();
            }
        }
    }
}

