/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.compiler;

import de.firemage.autograder.core.CodePosition;
import de.firemage.autograder.core.compiler.Compiler;
import de.firemage.autograder.core.file.SourceInfo;
import de.firemage.autograder.core.file.SourcePath;
import java.util.List;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public record CompilationDiagnostic(SourceInfo sourceInfo, SourcePath path, int line, int column, String message, String code) {
    CompilationDiagnostic(Diagnostic<? extends JavaFileObject> diagnostic, SourceInfo sourceInfo) {
        this(sourceInfo, sourceInfo.getCompilationUnit(diagnostic.getSource().toUri()).path(), (int)diagnostic.getLineNumber(), (int)diagnostic.getColumnNumber(), diagnostic.getMessage(Compiler.COMPILER_LOCALE), diagnostic.getCode());
    }

    public static String formatMultiple(List<CompilationDiagnostic> diagnostics) {
        return diagnostics.stream().map(CompilationDiagnostic::toString).collect(Collectors.joining(System.lineSeparator()));
    }

    public CodePosition codePosition() {
        return new CodePosition(this.sourceInfo, this.path, this.line, this.line, this.column, this.column);
    }

    @Override
    public String toString() {
        Object message = this.path.toString();
        if ((long)this.line != -1L) {
            message = (String)message + ":" + this.line;
        }
        return (String)message + " " + this.message;
    }
}

