/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.unnecessary;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;

@ExecutableCheck(reportedProblems={ProblemType.UNUSED_CODE_ELEMENT, ProblemType.UNUSED_CODE_ELEMENT_PRIVATE})
public class UnusedCodeElementCheck
extends IntegratedCheck {
    public static boolean isUnused(CtNamedElement ctElement, boolean hasMainMethod) {
        CtConstructor parentConstructor = (CtConstructor)ctElement.getParent(CtConstructor.class);
        if (parentConstructor == null && ctElement instanceof CtConstructor) {
            CtConstructor ctConstructor;
            parentConstructor = ctConstructor = (CtConstructor)ctElement;
        }
        if (parentConstructor != null && SpoonUtil.isSubtypeOf(parentConstructor.getType(), Throwable.class)) {
            return false;
        }
        Predicate<CtElement> shouldVisit = element -> true;
        if (ctElement instanceof CtMethod) {
            CtMethod method = (CtMethod)ctElement;
            shouldVisit = shouldVisit.and(Predicate.not(reference -> method.equals(reference.getParent(CtMethod.class))));
        }
        if (!SpoonUtil.hasAnyUses((CtElement)ctElement, shouldVisit)) {
            CtTypeMember ctTypeMember;
            CtModifiable ctModifiable;
            CtTypeMember ctTypeMember2;
            CtElement ctElement2;
            if (ctElement instanceof CtParameter && (ctElement2 = ctElement.getParent()) instanceof CtTypeMember && !(ctTypeMember2 = (CtTypeMember)ctElement2).getDeclaringType().isPrivate() && !hasMainMethod) {
                return false;
            }
            return !(ctElement instanceof CtModifiable) || (ctModifiable = (CtModifiable)ctElement).isPrivate() || !(ctModifiable instanceof CtTypeMember) || (ctTypeMember = (CtTypeMember)ctModifiable).getDeclaringType().isPrivate() || hasMainMethod;
        }
        return false;
    }

    private void checkUnused(StaticAnalysis staticAnalysis, CtNamedElement ctElement) {
        if (ctElement.isImplicit() || !ctElement.getPosition().isValidPosition()) {
            return;
        }
        if (UnusedCodeElementCheck.isUnused(ctElement, staticAnalysis.getCodeModel().hasMainMethod())) {
            CtModifiable ctModifiable;
            ProblemType problemType = ProblemType.UNUSED_CODE_ELEMENT;
            if (ctElement instanceof CtModifiable && (ctModifiable = (CtModifiable)ctElement).isPrivate()) {
                problemType = ProblemType.UNUSED_CODE_ELEMENT_PRIVATE;
            }
            String name = ctElement.getSimpleName();
            if (ctElement instanceof CtConstructor) {
                CtConstructor ctConstructor = (CtConstructor)ctElement;
                name = "%s()".formatted(ctConstructor.getDeclaringType().getSimpleName());
            }
            this.addLocalProblem((CtElement)ctElement, (Translatable)new LocalizedMessage("unused-element", Map.of("name", name)), problemType);
        }
    }

    @Override
    protected void check(final StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.getModel().getRootPackage().accept((CtVisitor)new CtScanner(){

            public <T> void visitCtLocalVariable(CtLocalVariable<T> ctLocalVariable) {
                UnusedCodeElementCheck.this.checkUnused(staticAnalysis, (CtNamedElement)ctLocalVariable);
                super.visitCtLocalVariable(ctLocalVariable);
            }

            public <T> void visitCtMethod(CtMethod<T> ctMethod) {
                if (SpoonUtil.isOverriddenMethod(ctMethod) || SpoonUtil.isMainMethod(ctMethod)) {
                    super.visitCtMethod(ctMethod);
                    return;
                }
                UnusedCodeElementCheck.this.checkUnused(staticAnalysis, (CtNamedElement)ctMethod);
                super.visitCtMethod(ctMethod);
            }

            public <T> void visitCtConstructor(CtConstructor<T> ctConstructor) {
                if (ctConstructor.isPrivate()) {
                    super.visitCtConstructor(ctConstructor);
                    return;
                }
                UnusedCodeElementCheck.this.checkUnused(staticAnalysis, (CtNamedElement)ctConstructor);
                super.visitCtConstructor(ctConstructor);
            }

            public <T> void visitCtParameter(CtParameter<T> ctParameter) {
                if (SpoonUtil.isInOverriddenMethod(ctParameter) || SpoonUtil.isInMainMethod(ctParameter) || ctParameter.getParent() instanceof CtLambda || ctParameter.getParent(CtInterface.class) != null) {
                    super.visitCtParameter(ctParameter);
                    return;
                }
                UnusedCodeElementCheck.this.checkUnused(staticAnalysis, (CtNamedElement)ctParameter);
                super.visitCtParameter(ctParameter);
            }

            public void visitCtTypeParameter(CtTypeParameter ctTypeParameter) {
                UnusedCodeElementCheck.this.checkUnused(staticAnalysis, (CtNamedElement)ctTypeParameter);
                super.visitCtTypeParameter(ctTypeParameter);
            }

            public <T> void visitCtField(CtField<T> ctField) {
                if (ctField.getSimpleName().equals("serialVersionUID")) {
                    super.visitCtField(ctField);
                    return;
                }
                UnusedCodeElementCheck.this.checkUnused(staticAnalysis, (CtNamedElement)ctField);
                super.visitCtField(ctField);
            }
        });
    }

    @Override
    public Optional<Integer> maximumProblems() {
        return Optional.of(6);
    }
}

