/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.unnecessary;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;

@ExecutableCheck(reportedProblems={ProblemType.EMPTY_BLOCK, ProblemType.EMPTY_CATCH})
public class EmptyBlockCheck
extends IntegratedCheck {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isEmptyBlock(CtBlock<?> ctBlock) {
        if (!SpoonUtil.getEffectiveStatements(ctBlock).isEmpty()) return false;
        if (ctBlock.getStatements().isEmpty()) return true;
        if (ctBlock.getStatements().stream().allMatch(CtComment.class::isInstance)) return false;
        return true;
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.getModel().getRootPackage().accept((CtVisitor)new CtScanner(){

            public <T> void visitCtBlock(CtBlock<T> ctBlock) {
                CtCatch ctCatch;
                if (ctBlock.isImplicit() || !ctBlock.getPosition().isValidPosition() || !EmptyBlockCheck.isEmptyBlock(ctBlock)) {
                    super.visitCtBlock(ctBlock);
                    return;
                }
                CtElement ctElement = ctBlock.getParent();
                if (ctElement instanceof CtCatch && (ctCatch = (CtCatch)ctElement).getBody().equals(ctBlock)) {
                    EmptyBlockCheck.this.addLocalProblem((CtElement)ctCatch, new LocalizedMessage("empty-catch-block"), ProblemType.EMPTY_CATCH);
                } else {
                    EmptyBlockCheck.this.addLocalProblem(ctBlock, new LocalizedMessage("empty-block"), ProblemType.EMPTY_BLOCK);
                }
                super.visitCtBlock(ctBlock);
            }

            public <T> void visitCtSwitch(CtSwitch<T> ctSwitch) {
                if (ctSwitch.getCases().isEmpty()) {
                    EmptyBlockCheck.this.addLocalProblem(ctSwitch, new LocalizedMessage("empty-block"), ProblemType.EMPTY_BLOCK);
                }
                super.visitCtSwitch(ctSwitch);
            }
        });
    }
}

