/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.oop;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.List;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtThrow;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;

@ExecutableCheck(reportedProblems={ProblemType.METHOD_USES_PLACEHOLDER_IMPLEMENTATION})
public class MethodShouldBeAbstractCheck
extends IntegratedCheck {
    private static LocalizedMessage formatExplanation(CtMethod<?> method) {
        return new LocalizedMessage("method-abstract-exp", Map.of("type", method.getDeclaringType().getQualifiedName(), "method", method.getSimpleName()));
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtClass<?>>(){

            public void process(CtClass<?> clazz) {
                if (!clazz.isAbstract()) {
                    return;
                }
                for (CtMethod method : clazz.getMethods()) {
                    CtConstructorCall call;
                    String type;
                    CtThrow ctThrow;
                    CtLiteral literal;
                    CtReturn ret;
                    CtExpression ctExpression;
                    if (!method.isPublic() && !method.isProtected() || method.isStatic() || method.isAbstract() || method.hasAnnotation(Override.class)) continue;
                    List<CtStatement> statements = SpoonUtil.getEffectiveStatements((CtStatement)method.getBody());
                    if (statements.isEmpty()) {
                        MethodShouldBeAbstractCheck.this.addLocalProblem((CtElement)method, MethodShouldBeAbstractCheck.formatExplanation(method), ProblemType.METHOD_USES_PLACEHOLDER_IMPLEMENTATION);
                        continue;
                    }
                    if (statements.size() != 1) continue;
                    CtStatement statement = statements.get(0);
                    if (statement instanceof CtReturn && (ctExpression = (ret = (CtReturn)statement).getReturnedExpression()) instanceof CtLiteral && (literal = (CtLiteral)ctExpression).getValue() == null) {
                        MethodShouldBeAbstractCheck.this.addLocalProblem((CtElement)method, MethodShouldBeAbstractCheck.formatExplanation(method), ProblemType.METHOD_USES_PLACEHOLDER_IMPLEMENTATION);
                        continue;
                    }
                    if (!(statement instanceof CtThrow) || !((ctExpression = (ctThrow = (CtThrow)statement).getThrownExpression()) instanceof CtConstructorCall) || !(type = (call = (CtConstructorCall)ctExpression).getType().getQualifiedName()).equals("java.lang.UnsupportedOperationException") && !type.equals("java.lang.IllegalStateException")) continue;
                    MethodShouldBeAbstractCheck.this.addLocalProblem((CtElement)method, MethodShouldBeAbstractCheck.formatExplanation(method), ProblemType.METHOD_USES_PLACEHOLDER_IMPLEMENTATION);
                }
            }
        });
    }
}

