/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.oop;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IdentifierNameUtils;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import spoon.processing.AbstractProcessor;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.SubtypeFilter;

@ExecutableCheck(reportedProblems={ProblemType.ABSTRACT_CLASS_WITHOUT_ABSTRACT_METHOD, ProblemType.USE_DIFFERENT_VISIBILITY, ProblemType.SHOULD_BE_INTERFACE, ProblemType.COMPOSITION_OVER_INHERITANCE})
public class InheritanceBadPractices
extends IntegratedCheck {
    @Override
    protected void check(final StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtClass<?>>(){

            public void process(CtClass<?> ctClass) {
                List fields = ctClass.getFields();
                Set methods = ctClass.getMethods();
                List subtypes = staticAnalysis.getModel().getElements((Filter)new SubtypeFilter(ctClass.getReference()).includingSelf(false));
                if (subtypes.isEmpty()) {
                    return;
                }
                if (fields.isEmpty() && ctClass.getSuperclass() == null) {
                    InheritanceBadPractices.this.addLocalProblem(ctClass, new LocalizedMessage("should-be-interface"), ProblemType.SHOULD_BE_INTERFACE);
                } else if (methods.isEmpty() && ctClass.getSuperclass() == null) {
                    String methodName = IdentifierNameUtils.toLowerCamelCase(ctClass.getSimpleName());
                    InheritanceBadPractices.this.addLocalProblem(ctClass, new LocalizedMessage("composition-over-inheritance", Map.of("suggestion", "%s %s()".formatted(ctClass.getSimpleName(), methodName))), ProblemType.COMPOSITION_OVER_INHERITANCE);
                }
                Set constructors = ctClass.getConstructors().stream().filter(ctElement -> !ctElement.isImplicit()).collect(Collectors.toSet());
                if (ctClass.isAbstract()) {
                    for (CtConstructor constructor : constructors) {
                        if (!constructor.isPublic()) continue;
                        InheritanceBadPractices.this.addLocalProblem((CtElement)constructor, new LocalizedMessage("use-different-visibility", Map.of("name", ctClass.getSimpleName(), "suggestion", "protected")), ProblemType.USE_DIFFERENT_VISIBILITY);
                    }
                }
                List<CtMethod> interfaceMethods = ctClass.getSuperInterfaces().stream().map(CtTypeReference::getTypeDeclaration).filter(Objects::nonNull).flatMap(ctType -> ctType.getMethods().stream()).filter(ctMethod -> methods.stream().noneMatch(method -> method.isOverriding(ctMethod))).toList();
                if (ctClass.isAbstract() && constructors.stream().noneMatch(CtModifiable::isAbstract) && methods.stream().noneMatch(CtModifiable::isAbstract) && !methods.isEmpty() && interfaceMethods.isEmpty()) {
                    InheritanceBadPractices.this.addLocalProblem(ctClass, new LocalizedMessage("abstract-class-without-abstract-method"), ProblemType.ABSTRACT_CLASS_WITHOUT_ABSTRACT_METHOD);
                }
            }
        });
    }
}

