/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.oop;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.declaration.CtElement;

@ExecutableCheck(reportedProblems={ProblemType.DO_NOT_USE_SYSTEM_EXIT})
public class DoNotUseSystemExit
extends IntegratedCheck {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasInvokedSystemExit(CtInvocation<?> ctInvocation) {
        CtExpression ctExpression = ctInvocation.getTarget();
        if (!(ctExpression instanceof CtTypeAccess)) return false;
        CtTypeAccess ctTypeAccess = (CtTypeAccess)ctExpression;
        if (!ctInvocation.getFactory().Type().createReference(System.class).equals(ctTypeAccess.getAccessedType())) return false;
        if (!ctInvocation.getExecutable().getSimpleName().equals("exit")) return false;
        return true;
    }

    private void checkCtInvocation(CtInvocation<?> ctInvocation) {
        if (this.hasInvokedSystemExit(ctInvocation)) {
            this.addLocalProblem((CtElement)ctInvocation, (Translatable)new LocalizedMessage("do-not-use-system-exit"), ProblemType.DO_NOT_USE_SYSTEM_EXIT);
        }
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtInvocation<?>>(){

            public void process(CtInvocation<?> ctInvocation) {
                DoNotUseSystemExit.this.checkCtInvocation(ctInvocation);
            }
        });
    }
}

