/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.oop;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import spoon.processing.AbstractProcessor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtType;

@ExecutableCheck(reportedProblems={ProblemType.AVOID_INNER_CLASSES})
public class AvoidInnerClasses
extends IntegratedCheck {
    private void checkCtType(CtType<?> ctType) {
        if (SpoonUtil.isInnerClass(ctType) && !ctType.isPrivate() && (ctType.isStatic() || ctType.isInterface() || ctType.isEnum() || ctType.isLocalType())) {
            this.addLocalProblem((CtElement)ctType, (Translatable)new LocalizedMessage("avoid-inner-classes"), ProblemType.AVOID_INNER_CLASSES);
        }
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtType<?>>(){

            public void process(CtType<?> ctType) {
                AvoidInnerClasses.this.checkCtType(ctType);
            }
        });
    }
}

