/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.general;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import de.firemage.autograder.event.GetFieldEvent;
import de.firemage.autograder.event.MethodEvent;
import de.firemage.autograder.event.PutFieldEvent;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;

@ExecutableCheck(reportedProblems={ProblemType.INSTANCE_FIELD_CAN_BE_LOCAL})
public class FieldShouldBeLocalCheck
extends IntegratedCheck {
    private static LocalizedMessage formatExplanation(CtField<?> field) {
        return new LocalizedMessage("field-local-exp", Map.of("field", field.getSimpleName(), "class", field.getDeclaringType().getQualifiedName()));
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, final DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtField<?>>(){

            public void process(CtField<?> field) {
                if (!field.isPrivate() || field.isFinal()) {
                    return;
                }
                boolean readBeforeWriteFound = false;
                boolean writeFound = false;
                block0: for (CtMethod method : field.getDeclaringType().getMethods()) {
                    for (MethodEvent event : dynamicAnalysis.findEventsForMethod(method)::iterator) {
                        PutFieldEvent e;
                        GetFieldEvent e2;
                        if (event instanceof GetFieldEvent && (e2 = (GetFieldEvent)event).getField().equals(field.getSimpleName())) {
                            readBeforeWriteFound = true;
                            break block0;
                        }
                        if (!(event instanceof PutFieldEvent) || !(e = (PutFieldEvent)event).getField().equals(field.getSimpleName())) continue;
                        writeFound = true;
                        continue block0;
                    }
                }
                if (!readBeforeWriteFound && writeFound) {
                    FieldShouldBeLocalCheck.this.addLocalProblem(field, FieldShouldBeLocalCheck.formatExplanation(field), ProblemType.INSTANCE_FIELD_CAN_BE_LOCAL);
                }
            }
        });
    }
}

