/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.exceptions;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtTry;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.CompositeFilter;
import spoon.reflect.visitor.filter.FilteringOperator;
import spoon.reflect.visitor.filter.TypeFilter;

@ExecutableCheck(reportedProblems={ProblemType.NUMBER_FORMAT_EXCEPTION_IGNORED})
public class NumberFormatExceptionIgnored
extends IntegratedCheck {
    private static boolean isNFECaught(CtInvocation<?> ctInvocation) {
        return ctInvocation.getParent((Filter)new CompositeFilter(FilteringOperator.INTERSECTION, new Filter[]{new TypeFilter(CtTry.class), ctTry -> ctTry.getCatchers().stream().anyMatch(ctCatch -> SpoonUtil.isTypeEqualTo(ctCatch.getParameter().getType(), NumberFormatException.class))})) != null;
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtInvocation<?>>(){

            public void process(CtInvocation<?> ctInvocation) {
                if (ctInvocation.isImplicit() || !ctInvocation.getPosition().isValidPosition()) {
                    return;
                }
                if (SpoonUtil.isSignatureEqualTo(ctInvocation.getExecutable(), Integer.TYPE, "parseInt", String.class) && !NumberFormatExceptionIgnored.isNFECaught(ctInvocation)) {
                    NumberFormatExceptionIgnored.this.addLocalProblem(ctInvocation, new LocalizedMessage("number-format-exception-ignored"), ProblemType.NUMBER_FORMAT_EXCEPTION_IGNORED);
                }
            }
        });
    }
}

