/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.exceptions;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.ExceptionUtil;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.List;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtThrow;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;

@ExecutableCheck(reportedProblems={ProblemType.EXCEPTION_WITHOUT_MESSAGE})
public class ExceptionMessageCheck
extends IntegratedCheck {
    private static boolean isExceptionWithoutMessage(CtExpression<?> expression) {
        CtConstructorCall ctorCall;
        return expression instanceof CtConstructorCall && ExceptionUtil.isRuntimeException((ctorCall = (CtConstructorCall)expression).getType()) && !ExceptionMessageCheck.hasMessage(ctorCall.getArguments());
    }

    private static boolean hasMessage(List<? extends CtExpression<?>> arguments) {
        if (arguments.isEmpty()) {
            return false;
        }
        CtExpression<?> ctExpression = arguments.get(0);
        String literal = SpoonUtil.tryGetStringLiteral(ctExpression).orElse(null);
        if (literal != null) {
            return !literal.isBlank();
        }
        return true;
    }

    private static boolean isInAllowedContext(CtElement ctElement) {
        CtConstructor ctConstructor = (CtConstructor)ctElement.getParent(CtConstructor.class);
        if (ctConstructor != null && ctConstructor.isPrivate()) {
            return true;
        }
        CtCase ctCase = (CtCase)ctElement.getParent(CtCase.class);
        return ctCase != null && ctCase.getCaseExpressions().isEmpty();
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtThrow>(){

            public void process(CtThrow throwStmt) {
                if (ExceptionMessageCheck.isExceptionWithoutMessage(throwStmt.getThrownExpression()) && !ExceptionMessageCheck.isInAllowedContext((CtElement)throwStmt)) {
                    ExceptionMessageCheck.this.addLocalProblem((CtElement)throwStmt, new LocalizedMessage("exception-message"), ProblemType.EXCEPTION_WITHOUT_MESSAGE);
                }
            }
        });
    }
}

