/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import de.firemage.autograder.core.integrated.evaluator.OperatorHelper;
import java.util.List;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.declaration.CtTypedElement;

@ExecutableCheck(reportedProblems={ProblemType.USE_OPERATOR_ASSIGNMENT})
public class UseOperatorAssignment
extends IntegratedCheck {
    private static final List<Class<?>> NON_COMMUTATIVE_TYPES = List.of(String.class);

    private boolean isCommutativeType(CtTypedElement<?> ctTypedElement) {
        return ctTypedElement.getType() == null || NON_COMMUTATIVE_TYPES.stream().map(ty -> ctTypedElement.getFactory().Type().createReference(ty)).noneMatch(ty -> ty.equals(ctTypedElement.getType()));
    }

    private boolean isCommutative(BinaryOperatorKind binaryOperatorKind) {
        return List.of(BinaryOperatorKind.AND, BinaryOperatorKind.OR, BinaryOperatorKind.BITXOR, BinaryOperatorKind.MUL, BinaryOperatorKind.PLUS).contains(binaryOperatorKind);
    }

    private boolean isAssignable(BinaryOperatorKind binaryOperatorKind) {
        return this.isCommutative(binaryOperatorKind) || List.of(BinaryOperatorKind.MOD, BinaryOperatorKind.MINUS, BinaryOperatorKind.DIV, BinaryOperatorKind.SL, BinaryOperatorKind.SR).contains(binaryOperatorKind);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtAssignment<?, ?>>(){

            public void process(CtAssignment<?, ?> assignment) {
                if (assignment instanceof CtOperatorAssignment) {
                    return;
                }
                CtExpression lhs = assignment.getAssigned();
                CtExpression rhs = assignment.getAssignment();
                if (lhs == null || rhs == null) {
                    return;
                }
                if (!(rhs instanceof CtBinaryOperator)) {
                    return;
                }
                CtBinaryOperator ctBinaryOperator = (CtBinaryOperator)rhs;
                BinaryOperatorKind operator = ctBinaryOperator.getKind();
                if (!UseOperatorAssignment.this.isAssignable(operator)) {
                    return;
                }
                CtExpression left = ctBinaryOperator.getLeftHandOperand();
                CtExpression right = ctBinaryOperator.getRightHandOperand();
                String simplifiedExpr = null;
                if (left.toString().equals(lhs.toString())) {
                    simplifiedExpr = "%s %s= %s".formatted(lhs, OperatorHelper.getOperatorText(operator), right);
                } else if (UseOperatorAssignment.this.isCommutative(operator) && UseOperatorAssignment.this.isCommutativeType((CtTypedElement<?>)ctBinaryOperator) && right.toString().equals(lhs.toString())) {
                    simplifiedExpr = "%s %s= %s".formatted(lhs, OperatorHelper.getOperatorText(operator), left);
                }
                if (simplifiedExpr != null) {
                    UseOperatorAssignment.this.addLocalProblem(assignment, new LocalizedMessage("use-operator-assignment-exp", Map.of("simplified", simplifiedExpr)), ProblemType.USE_OPERATOR_ASSIGNMENT);
                }
            }
        });
    }
}

