/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import spoon.javadoc.api.elements.JavadocReference;
import spoon.javadoc.api.elements.JavadocVisitor;
import spoon.javadoc.api.parsing.JavadocParser;
import spoon.reflect.code.CtJavaDoc;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtCompilationUnit;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtImport;
import spoon.reflect.declaration.CtImportKind;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.CompositeFilter;
import spoon.reflect.visitor.filter.FilteringOperator;
import spoon.reflect.visitor.filter.TypeFilter;

@ExecutableCheck(reportedProblems={ProblemType.UNUSED_IMPORT})
public class UnusedImport
extends IntegratedCheck {
    private static final Set<CtImportKind> SUPPORTED_IMPORTS = Set.of(CtImportKind.FIELD, CtImportKind.METHOD, CtImportKind.TYPE);

    private static boolean isJavaLangImport(CtImport ctImport) {
        CtPackageReference ctPackageReference = null;
        CtReference ctReference = ctImport.getReference();
        if (ctReference instanceof CtTypeReference) {
            CtTypeReference ctTypeReference = (CtTypeReference)ctReference;
            ctPackageReference = ctTypeReference.getTypeDeclaration().getPackage().getReference();
        } else {
            ctReference = ctImport.getReference();
            if (ctReference instanceof CtPackageReference) {
                CtPackageReference packageReference;
                ctPackageReference = packageReference = (CtPackageReference)ctReference;
            }
        }
        return ctPackageReference != null && ctPackageReference.getQualifiedName().equals("java.lang");
    }

    private static boolean isInnerType(CtElement ctElement) {
        CtType ctType;
        return ctElement instanceof CtType && SpoonUtil.isInnerClass((CtTypeMember)(ctType = (CtType)ctElement));
    }

    private void reportProblem(CtImport ctImport) {
        this.addLocalProblem((CtElement)ctImport, (Translatable)new LocalizedMessage("unused-import", Map.of("import", ctImport.prettyprint())), ProblemType.UNUSED_IMPORT);
    }

    private static boolean isReferencingTheSameElement(CtReference left, CtReference right) {
        return left.equals(right) || Objects.equals(SpoonUtil.getReferenceDeclaration(left), SpoonUtil.getReferenceDeclaration(right));
    }

    private static boolean hasAnyJavadocUses(CtReference ctReference, Filter<? extends CtJavaDoc> filter) {
        return ctReference.getFactory().getModel().filterChildren((Filter)new CompositeFilter(FilteringOperator.INTERSECTION, new Filter[]{filter, new TypeFilter(CtJavaDoc.class), ctJavaDoc -> {
            JavadocParser parser = new JavadocParser(ctJavaDoc.getRawContent(), ctJavaDoc.getParent());
            return parser.parse().stream().flatMap(element -> ((List)element.accept((JavadocVisitor)new ReferenceFinder())).stream()).anyMatch(otherReference -> UnusedImport.isReferencingTheSameElement(ctReference, otherReference));
        }})).first(CtJavaDoc.class) != null;
    }

    private boolean isInSamePackage(CtElement ctElement, CtCompilationUnit ctCompilationUnit) {
        SourcePosition position = SpoonUtil.findPosition(ctElement);
        if (position == null) {
            return false;
        }
        CtPackage declaredPackage = position.getCompilationUnit().getDeclaredPackage();
        return Objects.equals(declaredPackage, ctCompilationUnit.getDeclaredPackage());
    }

    private void checkImport(CtImport ctImport, CtCompilationUnit ctCompilationUnit, Collection<? super CtElement> importedElements) {
        Predicate<CtElement> isSameFile;
        boolean hasAnyUses;
        CtTypeReference ctTypeReference;
        CtReference ctReference;
        if (!(!UnusedImport.isJavaLangImport(ctImport) || (ctReference = ctImport.getReference()) instanceof CtTypeReference && SpoonUtil.isInnerClass((CtTypeMember)(ctTypeReference = (CtTypeReference)ctReference).getTypeDeclaration()))) {
            this.reportProblem(ctImport);
            return;
        }
        CtElement element = SpoonUtil.getReferenceDeclaration(ctImport.getReference());
        if (this.isInSamePackage(element, ctCompilationUnit) && !(element instanceof CtExecutable) && !UnusedImport.isInnerType(element)) {
            this.reportProblem(ctImport);
            return;
        }
        boolean isNewImport = importedElements.add((CtElement)element);
        if (!isNewImport) {
            this.reportProblem(ctImport);
            return;
        }
        Predicate<CtElement> isAllowed = ctElement -> true;
        if ((UnusedImport.isJavaLangImport(ctImport) || this.isInSamePackage(element, ctCompilationUnit)) && UnusedImport.isInnerType(element)) {
            isAllowed = isAllowed.and(ctElement -> {
                CtTypeReference ctTypeReference;
                return ctElement instanceof CtTypeReference && (ctTypeReference = (CtTypeReference)ctElement).getDeclaringType() != null && ctTypeReference.getDeclaringType().isImplicit();
            });
        }
        if (!(hasAnyUses = SpoonUtil.hasAnyUses(element, isAllowed = isAllowed.and(isSameFile = ctElement -> {
            SourcePosition position = SpoonUtil.findPosition(ctElement);
            return position != null && position.getCompilationUnit().equals(ctCompilationUnit);
        })))) {
            hasAnyUses = UnusedImport.hasAnyJavadocUses(ctImport.getReference(), (Filter<? extends CtJavaDoc>)((Filter)isSameFile::test));
        }
        if (!hasAnyUses) {
            this.reportProblem(ctImport);
        }
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        SpoonUtil.visitCtCompilationUnit(staticAnalysis.getModel(), ctCompilationUnit -> {
            HashSet importedElements = new HashSet();
            for (CtImport ctImport : ctCompilationUnit.getImports()) {
                if (!SUPPORTED_IMPORTS.contains(ctImport.getImportKind())) continue;
                this.checkImport(ctImport, (CtCompilationUnit)ctCompilationUnit, importedElements);
            }
        });
    }

    private static class ReferenceFinder
    implements JavadocVisitor<List<CtReference>> {
        private final List<CtReference> references = new ArrayList<CtReference>();

        private ReferenceFinder() {
        }

        public List<CtReference> defaultValue() {
            return this.references;
        }

        public List<CtReference> visitReference(JavadocReference reference) {
            this.references.add(reference.getReference());
            return (List)super.visitReference(reference);
        }
    }
}

