/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.ArrayList;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;

@ExecutableCheck(reportedProblems={ProblemType.TOO_MANY_EXCEPTIONS})
public class TooManyExceptions
extends IntegratedCheck {
    private static final int MAXIMUM_NUMBER_OF_EXCEPTIONS = 5;

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        final ArrayList declaredExceptions = new ArrayList();
        staticAnalysis.processWith(new AbstractProcessor<CtClass<?>>(){

            public void process(CtClass<?> ctClass) {
                if (ctClass.isImplicit() || !ctClass.getPosition().isValidPosition()) {
                    return;
                }
                if (SpoonUtil.isSubtypeOf(ctClass.getReference(), Exception.class)) {
                    declaredExceptions.add(ctClass);
                }
            }
        });
        if (declaredExceptions.size() > 5) {
            this.addLocalProblem((CtElement)declaredExceptions.get(0), (Translatable)new LocalizedMessage("too-many-exceptions", Map.of("count", declaredExceptions.size())), ProblemType.TOO_MANY_EXCEPTIONS);
        }
    }
}

