/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;

@ExecutableCheck(reportedProblems={ProblemType.REDUNDANT_SELF_ASSIGNMENT})
public class SelfAssignmentCheck
extends IntegratedCheck {
    private static CtTypeReference<?> findDeclaredType(CtFieldReference<?> ctFieldReference, CtTypeReference<?> ctTypeReference) {
        for (CtTypeReference current = ctTypeReference; current != null; current = current.getSuperclass()) {
            if (!current.getDeclaredFields().contains(ctFieldReference)) continue;
            return current;
        }
        return null;
    }

    private static <T> void adjustTarget(CtFieldAccess<T> ctFieldAccess) {
        CtExpression ctExpression = ctFieldAccess.getTarget();
        if (!(ctExpression instanceof CtThisAccess)) {
            return;
        }
        CtThisAccess ctThisAccess = (CtThisAccess)ctExpression;
        if (ctThisAccess.getType().getDeclaredFields().contains(ctFieldAccess.getVariable())) {
            return;
        }
        CtSuperAccess ctSuperAccess = ctFieldAccess.getFactory().createSuperAccess();
        ctSuperAccess.setImplicit(true);
        ctSuperAccess.setTarget(null);
        CtLocalVariableReference ctVariableReference = ctFieldAccess.getFactory().createLocalVariableReference();
        ctVariableReference.setSimpleName("");
        ctVariableReference.setParent((CtElement)ctSuperAccess);
        ctVariableReference.setImplicit(false);
        ctVariableReference.setType(SelfAssignmentCheck.findDeclaredType(ctFieldAccess.getVariable(), ctThisAccess.getType()));
        ctSuperAccess.setVariable((CtVariableReference)ctVariableReference);
        ctSuperAccess.setType(null);
        ctSuperAccess.setParent(ctFieldAccess);
        ctFieldAccess.setTarget((CtExpression)ctSuperAccess);
    }

    private static boolean isSelfAssignment(CtVariableWrite<?> lhs, CtVariableRead<?> rhs) {
        if (lhs instanceof CtFieldWrite) {
            CtFieldWrite left = (CtFieldWrite)lhs;
            if (rhs instanceof CtFieldRead) {
                CtFieldRead right = (CtFieldRead)rhs;
                SelfAssignmentCheck.adjustTarget(left);
                SelfAssignmentCheck.adjustTarget(right);
                return left.getTarget().equals(right.getTarget()) && lhs.getVariable().equals(rhs.getVariable());
            }
        }
        return lhs.getVariable().equals(rhs.getVariable());
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtAssignment<?, ?>>(){

            public void process(CtAssignment<?, ?> assignment) {
                CtVariableRead read;
                CtExpression rhs;
                CtExpression lhs;
                block5: {
                    block4: {
                        lhs = assignment.getAssigned();
                        rhs = assignment.getAssignment();
                        if (!(rhs instanceof CtVariableRead)) break block4;
                        read = (CtVariableRead)rhs;
                        if (lhs instanceof CtVariableWrite) break block5;
                    }
                    return;
                }
                CtVariableWrite write = (CtVariableWrite)lhs;
                if (SelfAssignmentCheck.isSelfAssignment(write, read)) {
                    SelfAssignmentCheck.this.addLocalProblem(assignment, new LocalizedMessage("self-assignment-exp", Map.of("lhs", lhs, "rhs", rhs)), ProblemType.REDUNDANT_SELF_ASSIGNMENT);
                }
            }
        });
    }
}

