/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import de.firemage.autograder.treeg.InvalidRegExSyntaxException;
import de.firemage.autograder.treeg.RegExParser;
import de.firemage.autograder.treeg.RegularExpression;
import de.firemage.autograder.treeg.ast.Alternative;
import de.firemage.autograder.treeg.ast.BoundaryMatcher;
import de.firemage.autograder.treeg.ast.CaptureGroupReference;
import de.firemage.autograder.treeg.ast.Chain;
import de.firemage.autograder.treeg.ast.CharacterClass;
import de.firemage.autograder.treeg.ast.CharacterClassEntry;
import de.firemage.autograder.treeg.ast.CharacterRange;
import de.firemage.autograder.treeg.ast.Group;
import de.firemage.autograder.treeg.ast.Lookaround;
import de.firemage.autograder.treeg.ast.PredefinedCharacterClass;
import de.firemage.autograder.treeg.ast.Quantifier;
import de.firemage.autograder.treeg.ast.RegExCharacter;
import de.firemage.autograder.treeg.ast.RegExNode;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.VariableAccessFilter;

@ExecutableCheck(reportedProblems={ProblemType.COMPLEX_REGEX})
public class RegexCheck
extends IntegratedCheck {
    private static final double MAX_ALLOWED_SCORE = 24.0;
    private static final List<String> REGEX_HINTS = List.of("?", "<", ">", "+", "*", "[", "]", "$", "^", "|", "\\");
    private static final int MIN_REGEX_HINTS = 2;

    private static boolean hasComment(CtElement ctElement) {
        CtVariable ctVariable;
        CtElement ctElement2;
        return !ctElement.getComments().isEmpty() && ctElement.getComments().stream().anyMatch(ctComment -> !ctComment.getContent().startsWith("#")) || (ctElement2 = ctElement.getParent()) instanceof CtVariable && RegexCheck.hasComment((CtElement)(ctVariable = (CtVariable)ctElement2));
    }

    private static boolean looksLikeRegex(String value) {
        return REGEX_HINTS.stream().filter(value::contains).count() >= 2L;
    }

    private static boolean isRegexInvocation(CtInvocation<?> ctInvocation) {
        CtTypeAccess ctTypeAccess;
        CtExecutableReference ctExecutable = ctInvocation.getExecutable();
        if (ctInvocation.getTarget() == null) {
            return false;
        }
        CtExpression ctExpression = ctInvocation.getTarget();
        return ctExpression instanceof CtTypeAccess && SpoonUtil.isTypeEqualTo((ctTypeAccess = (CtTypeAccess)ctExpression).getAccessedType(), Pattern.class) && List.of("matches", "compile").contains(ctExecutable.getSimpleName()) || SpoonUtil.isTypeEqualTo(ctInvocation.getTarget().getType(), String.class) && (SpoonUtil.isSignatureEqualTo(ctExecutable, Boolean.TYPE, "matches", String.class) || SpoonUtil.isSignatureEqualTo(ctExecutable, String.class, "replaceAll", String.class, String.class) || SpoonUtil.isSignatureEqualTo(ctExecutable, String.class, "replaceFirst", String.class, String.class) || SpoonUtil.isSignatureEqualTo(ctExecutable, String[].class, "split", String.class) || SpoonUtil.isSignatureEqualTo(ctExecutable, String[].class, "split", String.class, Integer.TYPE));
    }

    private static boolean isInAllowedContext(CtLiteral<?> ctLiteral) {
        CtInvocation ctInvocation;
        CtVariable ctVariable;
        CtElement parent = ctLiteral.getParent();
        if (parent instanceof CtVariable && SpoonUtil.isEffectivelyFinal(ctVariable = (CtVariable)parent)) {
            List invocations = parent.getFactory().getModel().getElements((Filter)new VariableAccessFilter(ctVariable.getReference()));
            return !invocations.isEmpty() && invocations.stream().allMatch(ctVariableAccess -> {
                CtInvocation ctInvocation;
                CtElement patt4507$temp = ctVariableAccess.getParent();
                return patt4507$temp instanceof CtInvocation && RegexCheck.isRegexInvocation(ctInvocation = (CtInvocation)patt4507$temp);
            });
        }
        return parent instanceof CtInvocation && RegexCheck.isRegexInvocation(ctInvocation = (CtInvocation)parent);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtLiteral<String>>(){

            public void process(CtLiteral<String> literal) {
                if (!SpoonUtil.isString(literal.getType()) || !RegexCheck.isInAllowedContext(literal)) {
                    return;
                }
                String value = (String)literal.getValue();
                if (value.length() <= 4) {
                    return;
                }
                if (RegexCheck.hasComment(literal)) {
                    return;
                }
                try {
                    Chain chain;
                    RegularExpression regex = RegExParser.parse((String)value);
                    RegExNode regExNode = regex.root();
                    if (regExNode instanceof Chain && (chain = (Chain)regExNode).children().stream().allMatch(c -> c instanceof RegExCharacter)) {
                        return;
                    }
                    double score = RegexCheck.scoreRegEx(regex);
                    if (score > 24.0) {
                        RegexCheck.this.addLocalProblem(literal, new LocalizedMessage("complex-regex", Map.of("score", score, "max", 24.0)), ProblemType.COMPLEX_REGEX);
                    }
                }
                catch (InvalidRegExSyntaxException invalidRegExSyntaxException) {
                    // empty catch block
                }
            }
        });
    }

    public static double scoreRegEx(RegularExpression regex) {
        return RegexCheck.scoreNode(regex.root());
    }

    private static double scoreNode(RegExNode node) {
        if (node instanceof RegExCharacter) {
            RegExCharacter c = (RegExCharacter)node;
            return RegexCheck.scoreCharacter(c);
        }
        if (node instanceof Alternative) {
            Alternative a = (Alternative)node;
            return RegexCheck.scoreAlternative(a);
        }
        if (node instanceof BoundaryMatcher) {
            BoundaryMatcher b = (BoundaryMatcher)node;
            return RegexCheck.scoreBoundaryMatcher(b);
        }
        if (node instanceof CaptureGroupReference) {
            CaptureGroupReference c = (CaptureGroupReference)node;
            return RegexCheck.scoreCaptureGroupReference(c);
        }
        if (node instanceof Chain) {
            Chain c = (Chain)node;
            return RegexCheck.scoreChain(c);
        }
        if (node instanceof CharacterClass) {
            CharacterClass c = (CharacterClass)node;
            return RegexCheck.scoreCharacterClass(c);
        }
        if (node instanceof Group) {
            Group g = (Group)node;
            return RegexCheck.scoreGroup(g);
        }
        if (node instanceof Lookaround) {
            Lookaround l = (Lookaround)node;
            return RegexCheck.scoreLookaround(l);
        }
        if (node instanceof PredefinedCharacterClass) {
            PredefinedCharacterClass p = (PredefinedCharacterClass)node;
            return RegexCheck.scorePredefinedCharacterClass(p);
        }
        if (node instanceof Quantifier) {
            Quantifier q = (Quantifier)node;
            return RegexCheck.scoreQuantifier(q);
        }
        throw new AssertionError((Object)"Unreachable");
    }

    private static double scoreCharacter(RegExCharacter character) {
        if (character.escaped()) {
            return 2.0;
        }
        return 0.0;
    }

    private static double scoreAlternative(Alternative alternative) {
        return Math.exp(alternative.alternatives().size()) * alternative.alternatives().stream().mapToDouble(RegexCheck::scoreNode).sum();
    }

    private static double scoreBoundaryMatcher(BoundaryMatcher matcher) {
        return 1.0;
    }

    private static double scoreCaptureGroupReference(CaptureGroupReference ref) {
        return 10.0;
    }

    private static double scoreChain(Chain chain) {
        return chain.children().stream().mapToDouble(RegexCheck::scoreNode).sum() + 1.0;
    }

    private static double scoreCharacterClass(CharacterClass c) {
        return (c.negated() ? 4.0 : 1.0) * c.ranges().stream().mapToDouble(RegexCheck::scoreCharacterClassEntry).sum();
    }

    private static double scoreCharacterClassEntry(CharacterClassEntry entry) {
        if (entry instanceof RegExCharacter) {
            RegExCharacter c = (RegExCharacter)entry;
            return RegexCheck.scoreCharacter(c) + 0.1;
        }
        if (entry instanceof CharacterRange) {
            CharacterRange r = (CharacterRange)entry;
            return RegexCheck.scoreCharacterRange(r);
        }
        throw new AssertionError((Object)"Unreachable");
    }

    private static double scoreCharacterRange(CharacterRange range) {
        return 2.0;
    }

    private static double scoreGroup(Group group) {
        double multiplier;
        switch (group.type()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case CAPTURING: {
                double d = 1.5;
                break;
            }
            case NON_CAPTURING: {
                double d = 10.0;
                break;
            }
            case INDEPENDENT_NON_CAPTURING: {
                double d = multiplier = 100.0;
            }
        }
        if (group.name() != null) {
            multiplier += 10.0;
        }
        if (group.flags() != null) {
            multiplier += Math.exp(group.flags().length() + 2);
        }
        return multiplier * RegexCheck.scoreNode(group.root());
    }

    private static double scoreLookaround(Lookaround lookaround) {
        return 10.0 * RegexCheck.scoreNode(lookaround.child());
    }

    private static double scorePredefinedCharacterClass(PredefinedCharacterClass c) {
        return switch (c.type()) {
            default -> throw new IncompatibleClassChangeError();
            case PredefinedCharacterClass.Type.ANY, PredefinedCharacterClass.Type.DIGIT, PredefinedCharacterClass.Type.WORD -> 1.0;
            case PredefinedCharacterClass.Type.NON_DIGIT, PredefinedCharacterClass.Type.WHITESPACE, PredefinedCharacterClass.Type.NON_WORD -> 5.0;
            case PredefinedCharacterClass.Type.HORIZONTAL_WHITESPACE, PredefinedCharacterClass.Type.NON_HORIZONTAL_WHITESPACE, PredefinedCharacterClass.Type.NON_WHITESPACE, PredefinedCharacterClass.Type.VERTICAL_WHITESPACE, PredefinedCharacterClass.Type.NON_VERTICAL_WHITESPACE -> 10.0;
        };
    }

    private static double scoreQuantifier(Quantifier quantifier) {
        return (switch (quantifier.type()) {
            default -> throw new IncompatibleClassChangeError();
            case Quantifier.Type.AT_MOST_ONCE, Quantifier.Type.ANY, Quantifier.Type.AT_LEAST_ONCE -> 2.0;
            case Quantifier.Type.TIMES, Quantifier.Type.OPEN_RANGE, Quantifier.Type.RANGE -> 5.0;
        }) * RegexCheck.scoreNode(quantifier.child());
    }
}

