/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Map;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtSwitchExpression;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;

@ExecutableCheck(reportedProblems={ProblemType.REDUNDANT_VARIABLE})
public class RedundantVariable
extends IntegratedCheck {
    private static final int MAX_EXPRESSION_SIZE = 40;

    private boolean isAllowedStatement(CtStatement ctStatement) {
        return ctStatement instanceof CtComment;
    }

    private boolean isComplexExpression(CtExpression<?> ctExpression) {
        return ctExpression instanceof CtSwitchExpression || ctExpression.toString().length() > 40;
    }

    private void checkVariableRead(CtStatement ctStatement, CtVariableRead<?> ctVariableRead) {
        CtLocalVariable ctLocalVariable;
        CtVariable ctVariable = ctVariableRead.getVariable().getDeclaration();
        if (!(ctVariable instanceof CtLocalVariable) || !(ctLocalVariable = (CtLocalVariable)ctVariable).getAnnotations().isEmpty() || SpoonUtil.findUsesOf(ctLocalVariable).size() != 1) {
            return;
        }
        if (ctLocalVariable.getDefaultExpression() != null && this.isComplexExpression(ctLocalVariable.getDefaultExpression())) {
            return;
        }
        CtStatement previousStatement = SpoonUtil.getPreviousStatement(ctStatement).orElse(null);
        while (!ctLocalVariable.equals(previousStatement) && this.isAllowedStatement(previousStatement)) {
            previousStatement = SpoonUtil.getPreviousStatement(previousStatement).orElse(null);
        }
        if (previousStatement == null) {
            return;
        }
        if (previousStatement.equals(ctLocalVariable)) {
            this.addLocalProblem((CtElement)ctStatement, (Translatable)new LocalizedMessage("redundant-variable", Map.of("name", ctLocalVariable.getSimpleName(), "suggestion", ctStatement.prettyprint().replace(ctLocalVariable.getSimpleName(), ctLocalVariable.getDefaultExpression().prettyprint()))), ProblemType.REDUNDANT_VARIABLE);
        }
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.getModel().getRootPackage().accept((CtVisitor)new CtScanner(){

            public <T> void visitCtInvocation(CtInvocation<T> ctInvocation) {
                Object e;
                if (!ctInvocation.getPosition().isValidPosition() || ctInvocation.isImplicit() || ctInvocation.getArguments().size() != 1 || !((e = ctInvocation.getArguments().get(0)) instanceof CtVariableRead)) {
                    super.visitCtInvocation(ctInvocation);
                    return;
                }
                CtVariableRead ctVariableRead = (CtVariableRead)e;
                RedundantVariable.this.checkVariableRead((CtStatement)ctInvocation, (CtVariableRead<?>)ctVariableRead);
                super.visitCtInvocation(ctInvocation);
            }

            public <T> void visitCtReturn(CtReturn<T> ctReturn) {
                CtExpression ctExpression;
                if (!ctReturn.getPosition().isValidPosition() || ctReturn.isImplicit() || !((ctExpression = ctReturn.getReturnedExpression()) instanceof CtVariableRead)) {
                    super.visitCtReturn(ctReturn);
                    return;
                }
                CtVariableRead ctVariableRead = (CtVariableRead)ctExpression;
                RedundantVariable.this.checkVariableRead((CtStatement)ctReturn, (CtVariableRead<?>)ctVariableRead);
                super.visitCtReturn(ctReturn);
            }
        });
    }
}

