/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.List;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtElement;

@ExecutableCheck(reportedProblems={ProblemType.MERGE_NESTED_IF, ProblemType.UNMERGED_ELSE_IF})
public class ChainedIfCheck
extends IntegratedCheck {
    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtIf>(){

            public void process(CtIf ctIf) {
                CtBlock ctBlock;
                CtStatement elseStatement;
                CtIf nestedIf;
                CtStatement ctStatement;
                if (ctIf.getThenStatement() == null) {
                    return;
                }
                List<CtStatement> thenStatements = SpoonUtil.getEffectiveStatements(ctIf.getThenStatement());
                if (thenStatements.size() == 1 && (ctStatement = thenStatements.get(0)) instanceof CtIf && ((nestedIf = (CtIf)ctStatement).getElseStatement() == null || SpoonUtil.getEffectiveStatements(nestedIf.getElseStatement()).isEmpty())) {
                    ChainedIfCheck.this.addLocalProblem((CtElement)ctIf.getCondition(), new LocalizedMessage("merge-nested-if", Map.of("suggestion", SpoonUtil.createBinaryOperator(ctIf.getCondition(), nestedIf.getCondition(), BinaryOperatorKind.AND).prettyprint())), ProblemType.MERGE_NESTED_IF);
                }
                if (!((elseStatement = ctIf.getElseStatement()) instanceof CtBlock) || (ctBlock = (CtBlock)elseStatement).getStatements().isEmpty()) {
                    return;
                }
                List<CtStatement> statements = SpoonUtil.getEffectiveStatements((CtStatement)ctBlock);
                if (statements.size() != 1) {
                    return;
                }
                CtStatement ctStatement2 = statements.get(0);
                if (ctStatement2 instanceof CtIf) {
                    CtIf ctElseIf = (CtIf)ctStatement2;
                    if (!elseStatement.isImplicit()) {
                        ChainedIfCheck.this.addLocalProblem((CtElement)ctElseIf.getCondition(), new LocalizedMessage("suggest-replacement", Map.of("original", "else {\"{\"} if (...) {\"{\"} ... {\"}\"} {\"}\"}", "suggestion", "else if (...) {\"{\"} ... {\"}\"}")), ProblemType.UNMERGED_ELSE_IF);
                    }
                }
            }
        });
    }
}

