/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.comment;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import de.firemage.autograder.event.ReferenceReturnEvent;
import java.util.Map;
import java.util.Optional;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtJavaDoc;
import spoon.reflect.code.CtJavaDocTag;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;

@ExecutableCheck(reportedProblems={ProblemType.JAVADOC_INCOMPLETE_RETURN_TAG})
public class JavadocReturnNullCheck
extends IntegratedCheck {
    @Override
    protected void check(StaticAnalysis staticAnalysis, final DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtMethod<?>>(){

            public void process(CtMethod<?> method) {
                if (method.isPrivate() || method.getType().isPrimitive()) {
                    return;
                }
                boolean returnsNull = dynamicAnalysis.findEventsForMethod(method).anyMatch(event -> {
                    ReferenceReturnEvent refRet;
                    return event instanceof ReferenceReturnEvent && (refRet = (ReferenceReturnEvent)event).returnedNull();
                });
                if (returnsNull) {
                    Optional<CtJavaDoc> javaDoc = SpoonUtil.getJavadoc(method);
                    if (javaDoc.isEmpty()) {
                        return;
                    }
                    Optional<CtJavaDocTag> returnTag = javaDoc.get().getTags().stream().filter(tag -> tag.getType().equals((Object)CtJavaDocTag.TagType.RETURN)).findFirst();
                    if (returnTag.isPresent() && !returnTag.get().getContent().contains("null")) {
                        JavadocReturnNullCheck.this.addLocalProblem((CtElement)javaDoc.get(), new LocalizedMessage("javadoc-return-null-exp", Map.of("method", method.getSignature())), ProblemType.JAVADOC_INCOMPLETE_RETURN_TAG);
                    }
                }
            }
        });
    }
}

