/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.api;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.check.general.ForToForEachLoop;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.ForLoopRange;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtBodyHolder;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtTypeReference;

@ExecutableCheck(reportedProblems={ProblemType.COMMON_REIMPLEMENTATION_SUBLIST})
public class UseSubList
extends IntegratedCheck {
    private void checkSubList(CtFor ctFor) {
        CtLiteral ctLiteral;
        CtExpression<Integer> ctExpression;
        ForLoopRange forLoopRange = ForLoopRange.fromCtFor(ctFor).orElse(null);
        if (forLoopRange == null) {
            return;
        }
        CtVariable ctListVariable = ForToForEachLoop.getForEachLoopVariable((CtBodyHolder)ctFor, forLoopRange, ForToForEachLoop.LOOP_VARIABLE_ACCESS_LIST).orElse(null);
        if (ctListVariable == null) {
            return;
        }
        CtTypeReference listElementType = ctFor.getFactory().createCtTypeReference(Object.class);
        if (ctListVariable.getType().getActualTypeArguments().size() == 1) {
            listElementType = (CtTypeReference)ctListVariable.getType().getActualTypeArguments().get(0);
        }
        if ((ctExpression = SpoonUtil.resolveConstant(forLoopRange.start())) instanceof CtLiteral && (Integer)(ctLiteral = (CtLiteral)ctExpression).getValue() == 0 && ForToForEachLoop.findIterable(forLoopRange).isPresent()) {
            return;
        }
        this.addLocalProblem((CtElement)ctFor, (Translatable)new LocalizedMessage("common-reimplementation", Map.of("suggestion", "for (%s value : %s.subList(%s, %s)) { ... }".formatted(listElementType.unbox().prettyprint(), ctListVariable.getSimpleName(), forLoopRange.start().prettyprint(), forLoopRange.end().prettyprint()))), ProblemType.COMMON_REIMPLEMENTATION_SUBLIST);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtFor>(){

            public void process(CtFor ctFor) {
                if (ctFor.isImplicit() || !ctFor.getPosition().isValidPosition()) {
                    return;
                }
                UseSubList.this.checkSubList(ctFor);
            }
        });
    }
}

