/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.api;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.ForLoopRange;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.List;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;

@ExecutableCheck(reportedProblems={ProblemType.COMMON_REIMPLEMENTATION_ARRAY_COPY})
public class UseArrayCopy
extends IntegratedCheck {
    private void checkArrayCopy(CtFor ctFor) {
        CtAssignment ctAssignment;
        ForLoopRange forLoopRange = ForLoopRange.fromCtFor(ctFor).orElse(null);
        List<CtStatement> statements = SpoonUtil.getEffectiveStatements(ctFor.getBody());
        if (statements.size() != 1 || forLoopRange == null) {
            return;
        }
        CtStatement ctStatement = statements.get(0);
        if (ctStatement instanceof CtAssignment && !((ctAssignment = (CtAssignment)ctStatement) instanceof CtOperatorAssignment) && (ctStatement = ctAssignment.getAssigned()) instanceof CtArrayAccess) {
            CtArrayAccess lhs = (CtArrayAccess)ctStatement;
            ctStatement = ctAssignment.getAssignment();
            if (ctStatement instanceof CtArrayAccess) {
                CtVariableRead index;
                CtArrayAccess rhs = (CtArrayAccess)ctStatement;
                if (lhs.getTarget() != null && rhs.getTarget() != null && lhs.getIndexExpression().equals(rhs.getIndexExpression()) && (ctStatement = lhs.getIndexExpression()) instanceof CtVariableRead && (index = (CtVariableRead)ctStatement).getVariable().equals(forLoopRange.loopVariable())) {
                    this.addLocalProblem((CtElement)ctFor, (Translatable)new LocalizedMessage("common-reimplementation", Map.of("suggestion", "System.arraycopy(%s, %s, %s, %s, %s)".formatted(rhs.getTarget().prettyprint(), forLoopRange.start().prettyprint(), lhs.getTarget().prettyprint(), forLoopRange.start().prettyprint(), forLoopRange.length().prettyprint()))), ProblemType.COMMON_REIMPLEMENTATION_ARRAY_COPY);
                }
            }
        }
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtFor>(){

            public void process(CtFor ctFor) {
                if (ctFor.isImplicit() || !ctFor.getPosition().isValidPosition()) {
                    return;
                }
                UseArrayCopy.this.checkArrayCopy(ctFor);
            }
        });
    }
}

