/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.api;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtTypeAccess;

@ExecutableCheck(reportedProblems={ProblemType.SIMPLIFY_ARRAYS_FILL})
public class SimplifyArraysFill
extends IntegratedCheck {
    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtInvocation<?>>(){

            public void process(CtInvocation<?> ctInvocation) {
                Integer number;
                CtLiteral ctLiteral;
                CtTypeAccess ctTypeAccess;
                if (ctInvocation.isImplicit() || !ctInvocation.getPosition().isValidPosition()) {
                    return;
                }
                CtExpression ctExpression = ctInvocation.getTarget();
                if (!(ctExpression instanceof CtTypeAccess && SpoonUtil.isTypeEqualTo((ctTypeAccess = (CtTypeAccess)ctExpression).getAccessedType(), Arrays.class) && ctInvocation.getExecutable().getSimpleName().equals("fill") && ctInvocation.getArguments().size() == 4)) {
                    return;
                }
                List args = ctInvocation.getArguments();
                Object object = SpoonUtil.resolveConstant((CtExpression)args.get(1));
                if (object instanceof CtLiteral && (object = (ctLiteral = (CtLiteral)object).getValue()) instanceof Integer && (number = (Integer)object) == 0 && (object = args.get(2)) instanceof CtFieldAccess) {
                    CtFieldAccess ctFieldAccess = (CtFieldAccess)object;
                    if (((CtExpression)args.get(0)).equals(ctFieldAccess.getTarget()) && ctFieldAccess.getVariable().getSimpleName().equals("length")) {
                        SimplifyArraysFill.this.addLocalProblem(ctInvocation, new LocalizedMessage("common-reimplementation", Map.of("suggestion", "Arrays.fill(%s, %s)".formatted(args.get(0), args.get(3)))), ProblemType.SIMPLIFY_ARRAYS_FILL);
                    }
                }
            }
        });
    }
}

