/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.api;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.declaration.CtElement;

@ExecutableCheck(reportedProblems={ProblemType.DEPRECATED_COLLECTION_USED})
public class OldCollectionCheck
extends IntegratedCheck {
    private void reportProblem(CtElement ctElement, String original, String suggestion) {
        this.addLocalProblem(ctElement, (Translatable)new LocalizedMessage("suggest-replacement", Map.of("original", original, "suggestion", suggestion)), ProblemType.DEPRECATED_COLLECTION_USED);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtConstructorCall<?>>(){

            public void process(CtConstructorCall ctConstructorCall) {
                switch (ctConstructorCall.getType().getQualifiedName()) {
                    case "java.util.Vector": {
                        OldCollectionCheck.this.reportProblem((CtElement)ctConstructorCall, "Vector", "ArrayList");
                        break;
                    }
                    case "java.util.Hashtable": {
                        OldCollectionCheck.this.reportProblem((CtElement)ctConstructorCall, "Hashtable", "HashMap");
                        break;
                    }
                    case "java.util.Stack": {
                        OldCollectionCheck.this.reportProblem((CtElement)ctConstructorCall, "Stack", "Deque");
                    }
                }
            }
        });
    }
}

