/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.api;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.check.api.UseEnumValues;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;

@ExecutableCheck(reportedProblems={ProblemType.COLLECTION_ADD_ALL, ProblemType.COMMON_REIMPLEMENTATION_ADD_ENUM_VALUES, ProblemType.COMMON_REIMPLEMENTATION_ADD_ALL})
public class CollectionAddAll
extends IntegratedCheck {
    private static final int MIN_ADD_ALL_SIZE = 4;

    private static <T> boolean isOrderedCollection(CtTypeReference<T> ctTypeReference) {
        return Stream.of(List.class).map(ctClass -> ctTypeReference.getFactory().createCtTypeReference(ctClass)).anyMatch(arg_0 -> ctTypeReference.isSubtypeOf(arg_0));
    }

    private void reportProblem(CtVariable<?> ctVariable, List<? extends CtExpression<?>> addedValues) {
        String values = "List.of(%s)".formatted(addedValues.stream().map(CtElement::prettyprint).collect(Collectors.joining(", ")));
        ArrayList fieldReads = new ArrayList();
        CtEnum<?> ctEnum = null;
        for (CtExpression<?> value : addedValues) {
            UseEnumValues.CtEnumFieldRead fieldRead = UseEnumValues.CtEnumFieldRead.of(value).orElse(null);
            if (fieldRead == null) {
                ctEnum = null;
                break;
            }
            if (ctEnum == null) {
                ctEnum = fieldRead.ctEnum();
            }
            if (!ctEnum.equals(fieldRead.ctEnum())) {
                ctEnum = null;
                break;
            }
            fieldReads.add(fieldRead.ctEnumValue());
        }
        if (ctEnum != null && UseEnumValues.checkEnumValues(ctEnum, CollectionAddAll.isOrderedCollection(ctVariable.getType()), fieldReads)) {
            this.addLocalProblem(addedValues.get(0).getParent(CtStatement.class), (Translatable)new LocalizedMessage("common-reimplementation", Map.of("suggestion", "%s.addAll(Arrays.asList(%s.values()))".formatted(ctVariable.getSimpleName(), ctEnum.getSimpleName()))), ProblemType.COMMON_REIMPLEMENTATION_ADD_ENUM_VALUES);
            return;
        }
        if (addedValues.size() < 4) {
            return;
        }
        this.addLocalProblem(addedValues.get(0).getParent(CtStatement.class), (Translatable)new LocalizedMessage("common-reimplementation", Map.of("suggestion", "%s.addAll(%s)".formatted(ctVariable.getSimpleName(), values))), ProblemType.COLLECTION_ADD_ALL);
    }

    private void checkAddAll(CtBlock<?> ctBlock) {
        List<CtStatement> statements = SpoonUtil.getEffectiveStatements(ctBlock);
        CtVariableReference<?> collection = null;
        ArrayList addedValues = new ArrayList();
        for (CtStatement ctStatement : statements) {
            AddInvocation addInvocation = AddInvocation.of(ctStatement).orElse(null);
            if (addInvocation == null) {
                if (addedValues.size() > 1 && collection != null) {
                    this.reportProblem(collection.getDeclaration(), addedValues);
                }
                collection = null;
                continue;
            }
            if (collection == null) {
                collection = addInvocation.collection();
                addedValues.clear();
            }
            if (!collection.equals(addInvocation.collection())) {
                if (addedValues.size() > 1) {
                    this.reportProblem(collection.getDeclaration(), addedValues);
                }
                collection = null;
                continue;
            }
            addedValues.add(addInvocation.value());
        }
        if (addedValues.size() > 1 && collection != null) {
            this.reportProblem(collection.getDeclaration(), addedValues);
        }
    }

    private void checkAddAll(CtForEach ctFor) {
        CtVariableRead ctVariableRead;
        CtInvocation ctInvocation;
        List<CtStatement> statements = SpoonUtil.getEffectiveStatements(ctFor.getBody());
        if (statements.size() != 1) {
            return;
        }
        Object object = statements.get(0);
        if (object instanceof CtInvocation && SpoonUtil.isSubtypeOf((ctInvocation = (CtInvocation)object).getTarget().getType(), Collection.class) && SpoonUtil.isSignatureEqualTo(ctInvocation.getExecutable(), Boolean.TYPE, "add", Object.class) && ctInvocation.getExecutable().getParameters().size() == 1 && (object = ctInvocation.getArguments().get(0)) instanceof CtVariableRead && (ctVariableRead = (CtVariableRead)object).getVariable().equals(ctFor.getVariable().getReference())) {
            if (!((CtExpression)ctInvocation.getArguments().get(0)).getTypeCasts().isEmpty()) {
                return;
            }
            String addAllArg = ctFor.getExpression().prettyprint();
            if (ctFor.getExpression().getType().isArray()) {
                addAllArg = "Arrays.asList(%s)".formatted(addAllArg);
            }
            this.addLocalProblem((CtElement)ctFor, (Translatable)new LocalizedMessage("common-reimplementation", Map.of("suggestion", "%s.addAll(%s)".formatted(ctInvocation.getTarget().prettyprint(), addAllArg))), ProblemType.COMMON_REIMPLEMENTATION_ADD_ALL);
        }
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.getModel().getRootPackage().accept((CtVisitor)new CtScanner(){

            public <T> void visitCtBlock(CtBlock<T> ctBlock) {
                if (ctBlock.isImplicit() || !ctBlock.getPosition().isValidPosition()) {
                    super.visitCtBlock(ctBlock);
                    return;
                }
                CollectionAddAll.this.checkAddAll(ctBlock);
                super.visitCtBlock(ctBlock);
            }

            public void visitCtForEach(CtForEach ctFor) {
                if (ctFor.isImplicit() || !ctFor.getPosition().isValidPosition()) {
                    super.visitCtForEach(ctFor);
                    return;
                }
                CollectionAddAll.this.checkAddAll(ctFor);
                super.visitCtForEach(ctFor);
            }
        });
    }

    private record AddInvocation(CtVariableReference<?> collection, CtExecutableReference<?> executableReference, CtExpression<?> value) {
        public static Optional<AddInvocation> of(CtStatement ctStatement) {
            CtVariableAccess ctVariableAccess;
            CtInvocation ctInvocation;
            CtExpression ctExpression;
            CtType collectionType = ctStatement.getFactory().Type().get(Collection.class);
            if (!(ctStatement instanceof CtInvocation) || !((ctExpression = (ctInvocation = (CtInvocation)ctStatement).getTarget()) instanceof CtVariableAccess) || (ctVariableAccess = (CtVariableAccess)ctExpression).getVariable().getType() instanceof CtTypeParameterReference || !ctVariableAccess.getVariable().getType().isSubtypeOf(collectionType.getReference())) {
                return Optional.empty();
            }
            CtExecutableReference executableReference = ctInvocation.getExecutable();
            CtVariableReference collection = ctVariableAccess.getVariable();
            if (!SpoonUtil.isSignatureEqualTo(executableReference, Boolean.TYPE, "add", Object.class)) {
                return Optional.empty();
            }
            return Optional.of(new AddInvocation(collection, executableReference, (CtExpression)ctInvocation.getArguments().get(0)));
        }
    }
}

