/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.api;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.List;
import java.util.Map;
import java.util.Set;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtTypeReference;

@ExecutableCheck(reportedProblems={ProblemType.COMMON_REIMPLEMENTATION_ITERABLE_DUPLICATES})
public class CheckIterableDuplicates
extends IntegratedCheck {
    private static String buildSuggestion(CtExpression<?> ctExpression, boolean isNegated) {
        CtTypeReference type = ctExpression.getType();
        String leftSide = ctExpression.prettyprint();
        String rightSide = "%s.size()".formatted(leftSide);
        if (type.isArray()) {
            leftSide = "Arrays.asList(%s)".formatted(leftSide);
            rightSide = "%s.length".formatted(ctExpression.prettyprint());
        }
        if (isNegated) {
            return "new HashSet<>(%s).size() != %s".formatted(leftSide, rightSide);
        }
        return "new HashSet<>(%s).size() == %s".formatted(leftSide, rightSide);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtForEach>(){

            public void process(CtForEach ctForEach) {
                Boolean value;
                block12: {
                    block11: {
                        CtVariableRead ctVariableRead;
                        CtUnaryOperator ctUnaryOperator;
                        CtAssignment ctAssignment;
                        Object ctLiteral;
                        CtReturn ctReturn;
                        CtStatement ctStatement;
                        CtStatement ctStatement2;
                        if (ctForEach.isImplicit() || !ctForEach.getPosition().isValidPosition()) {
                            return;
                        }
                        List<CtStatement> statements = SpoonUtil.getEffectiveStatements(ctForEach.getBody());
                        if (statements.size() != 1 || !((ctStatement2 = statements.get(0)) instanceof CtIf)) {
                            return;
                        }
                        CtIf ctIf = (CtIf)ctStatement2;
                        if (ctIf.getElseStatement() != null || ctIf.getThenStatement() == null) {
                            return;
                        }
                        List<CtStatement> ifStatements = SpoonUtil.getEffectiveStatements(ctIf.getThenStatement());
                        if (ifStatements.isEmpty()) {
                            return;
                        }
                        Object effectValue = null;
                        if (ifStatements.size() == 1 && (ctStatement = ifStatements.get(0)) instanceof CtReturn && (ctStatement = (ctReturn = (CtReturn)ctStatement).getReturnedExpression()) instanceof CtLiteral) {
                            effectValue = ctLiteral = (CtLiteral)ctStatement;
                        }
                        if (ifStatements.size() == 2 && (ctStatement = ifStatements.get(0)) instanceof CtAssignment && (ctStatement = (ctAssignment = (CtAssignment)ctStatement).getAssignment()) instanceof CtLiteral) {
                            ctLiteral = (CtLiteral)ctStatement;
                            if (ifStatements.get(1) instanceof CtBreak) {
                                effectValue = ctLiteral;
                            }
                        }
                        if (effectValue == null || !((ctLiteral = effectValue.getValue()) instanceof Boolean)) {
                            return;
                        }
                        value = (Boolean)ctLiteral;
                        Object object = ctIf.getCondition();
                        if (!(object instanceof CtUnaryOperator) || (ctUnaryOperator = (CtUnaryOperator)object).getKind() != UnaryOperatorKind.NOT || !((object = ctUnaryOperator.getOperand()) instanceof CtInvocation)) break block11;
                        CtInvocation ctInvocation = (CtInvocation)object;
                        if (SpoonUtil.isTypeEqualTo(ctInvocation.getExecutable().getType(), Boolean.TYPE) && ctInvocation.getExecutable().getSimpleName().equals("add") && ctInvocation.getArguments().size() == 1 && (object = ctInvocation.getArguments().get(0)) instanceof CtVariableRead && (ctVariableRead = (CtVariableRead)object).getVariable().equals(ctForEach.getVariable().getReference()) && SpoonUtil.isSubtypeOf(ctInvocation.getTarget().getType(), Set.class)) break block12;
                    }
                    return;
                }
                String suggestion = CheckIterableDuplicates.buildSuggestion(ctForEach.getExpression(), Boolean.TRUE.equals(value));
                CheckIterableDuplicates.this.addLocalProblem((CtElement)ctForEach, new LocalizedMessage("common-reimplementation", Map.of("suggestion", suggestion)), ProblemType.COMMON_REIMPLEMENTATION_ITERABLE_DUPLICATES);
            }
        });
    }
}

