/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.spotbugs;

import de.firemage.autograder.core.Problem;
import de.firemage.autograder.core.spotbugs.InCodeBugReporter;
import de.firemage.autograder.core.spotbugs.SpotbugsCheck;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;

public class SpotbugsLinter {
    public List<Problem> lint(Path jar, List<SpotbugsCheck> checks) throws IOException, InterruptedException {
        try (Project project = new Project();){
            List<Problem> list;
            project.addFile(jar.toAbsolutePath().toString());
            InCodeBugReporter reporter = new InCodeBugReporter(project);
            try (FindBugs2 findBugs = new FindBugs2();){
                findBugs.setBugReporter((BugReporter)reporter);
                findBugs.setProject(project);
                UserPreferences userPreferences = UserPreferences.createDefaultUserPreferences();
                userPreferences.setEffort("default");
                userPreferences.enableAllDetectors(true);
                DetectorFactoryCollection collection = DetectorFactoryCollection.instance();
                userPreferences.enableDetector(collection.getFactory("TestingGround"), false);
                userPreferences.enableDetector(collection.getFactory("CheckCalls"), false);
                userPreferences.enableDetector(collection.getFactory("Noise"), false);
                userPreferences.enableDetector(collection.getFactory("ViewCFG"), false);
                userPreferences.getFilterSettings().clearAllCategories();
                findBugs.setDetectorFactoryCollection(collection);
                findBugs.setUserPreferences(userPreferences);
                findBugs.finishSettings();
                findBugs.execute();
                list = reporter.getProblems(checks);
            }
            return list;
        }
    }
}

