/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.pmd;

import de.firemage.autograder.core.Problem;
import de.firemage.autograder.core.pmd.PMDCheck;
import de.firemage.autograder.core.pmd.PMDInCodeProblem;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.renderers.AbstractIncrementingRenderer;
import org.apache.commons.io.output.NullWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProblemRenderer
extends AbstractIncrementingRenderer {
    private static final Logger log = LoggerFactory.getLogger(ProblemRenderer.class);
    private final Path root;
    private final Map<String, PMDCheck> checks;
    private final List<Problem> problems = new ArrayList<Problem>();

    public ProblemRenderer(Map<String, PMDCheck> checks, Path root) {
        super("Custom renderer", "Creates InCodeProblems");
        this.checks = checks;
        this.root = root;
        super.setWriter((Writer)new NullWriter());
    }

    public void renderFileViolations(Iterator<RuleViolation> violations) {
        violations.forEachRemaining(violation -> this.problems.add(new PMDInCodeProblem(this.checks.get(violation.getRule().getName()), (RuleViolation)violation, this.root)));
    }

    public String defaultFileExtension() {
        return null;
    }

    public void end() {
        for (Report.ConfigurationError error : this.configErrors) {
            log.error("PMD config error: " + error.issue());
        }
    }

    public void start() {
    }

    public void flush() {
    }

    public List<Problem> getProblems() {
        return Collections.unmodifiableList(this.problems);
    }
}

