/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.pmd;

import de.firemage.autograder.core.Problem;
import de.firemage.autograder.core.file.UploadedFile;
import de.firemage.autograder.core.pmd.PMDCheck;
import de.firemage.autograder.core.pmd.ProblemRenderer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.renderers.Renderer;

public class PMDLinter {
    public List<Problem> lint(UploadedFile file, List<PMDCheck> checks) throws IOException {
        PMDConfiguration config = new PMDConfiguration();
        config.setMinimumPriority(RulePriority.LOW);
        config.setIgnoreIncrementalAnalysis(true);
        config.setReportShortNames(true);
        config.setDefaultLanguageVersion(LanguageRegistry.findLanguageByTerseName((String)"java").getVersion(file.getVersion().getVersionString()));
        HashMap<String, PMDCheck> idMap = new HashMap<String, PMDCheck>();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        int idCounter = 0;
        for (PMDCheck check : checks) {
            for (Rule rule : check.getRules()) {
                String id = String.valueOf(idCounter++);
                rule.setName(id);
                idMap.put(id, check);
                rules.add(rule);
            }
        }
        ProblemRenderer renderer = new ProblemRenderer(idMap, file.getFile());
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)config);){
            pmd.addRuleSet(RuleSet.create((String)"Autograder Configuration (Generated)", (String)"", null, List.of(), List.of(), rules));
            pmd.addRenderer((Renderer)renderer);
            pmd.files().addDirectory(file.getFile());
            pmd.performAnalysis();
        }
        return renderer.getProblems();
    }
}

