/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.pmd;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.Check;
import java.util.List;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.rule.XPathRule;
import net.sourceforge.pmd.lang.rule.xpath.XPathVersion;

public abstract class PMDCheck
implements Check {
    private final LocalizedMessage description;
    private final List<Rule> rules;
    private final LocalizedMessage explanation;
    private final ProblemType problemType;

    protected PMDCheck(LocalizedMessage description, LocalizedMessage explanation, Rule rule, ProblemType problemType) {
        this(description, explanation, List.of(rule), problemType);
    }

    protected PMDCheck(LocalizedMessage description, Rule rule, ProblemType problemType) {
        this(description, null, List.of(rule), problemType);
    }

    protected PMDCheck(LocalizedMessage description, List<Rule> rules, ProblemType problemType) {
        this(description, null, rules, problemType);
    }

    protected PMDCheck(LocalizedMessage description, LocalizedMessage explanation, List<Rule> rules, ProblemType problemType) {
        this.description = description;
        this.explanation = explanation;
        this.rules = rules;
        this.problemType = problemType;
        for (Rule rule : rules) {
            if (rule.getMessage() != null) continue;
            rule.setMessage("");
        }
    }

    protected static XPathRule createXPathRule(String name, String explanation, String expression) {
        XPathRule rule = new XPathRule(XPathVersion.XPATH_2_0, expression);
        rule.setName(name);
        rule.setMessage(explanation);
        rule.setLanguage(LanguageRegistry.findLanguageByTerseName((String)"java"));
        return rule;
    }

    @Override
    public LocalizedMessage getLinter() {
        return new LocalizedMessage("linter-pmd");
    }

    @Override
    public LocalizedMessage getDescription() {
        return this.description;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public LocalizedMessage getExplanation() {
        return this.explanation;
    }

    public ProblemType getProblemType() {
        return this.problemType;
    }
}

